/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.nifti;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import java.io.File;
import java.io.IOException;
import org.nrg.nifti.Nifti_Reader;
import org.nrg.plexiViewer.Reader.ImageReader;
import org.nrg.plexiViewer.Reader.ReaderUtils;
import org.nrg.plexiViewer.utils.FileUtils;

public class NiftiReader
implements ImageReader {
    private boolean zipped = false;
    private String name;
    private String directory;
    private boolean littleEndian = false;
    private boolean isNiftiData = false;
    private double cal_min = 0.0;
    private double cal_max = 0.0;
    private int nChannels = 1;
    private int depth = 1;
    private int frames = 1;
    private boolean complex;
    private FileInfo fi;

    public NiftiReader(String dir, String filename) {
        this.directory = dir;
        this.name = filename;
    }

    public NiftiReader(String filePath) {
        int i = filePath.lastIndexOf(File.separator);
        if (i != -1) {
            this.directory = filePath.substring(0, i);
            this.name = filePath.substring(i + 1);
        } else {
            this.name = filePath;
            this.directory = "";
        }
    }

    public ImagePlus getImagePlus() {
        Nifti_Reader nifti_reader = new Nifti_Reader();
        ImagePlus img = nifti_reader.load(this.directory, this.name);
        nifti_reader.doPostLoadingActions(img);
        this.fi = img.getOriginalFileInfo();
        return img;
    }

    @Override
    public FileInfo getFileInfo() {
        if (this.fi != null) {
            return this.fi;
        }
        Nifti_Reader nifti_reader = new Nifti_Reader();
        String hdrName = this.name;
        String imgName = this.name;
        String suffix = "";
        if (this.name.endsWith(".gz") || this.name.endsWith(".GZ")) {
            suffix = this.name.substring(this.name.length() - 3);
            this.name = this.name.substring(0, this.name.length() - 3);
        }
        if (this.name.endsWith(".img") || this.name.endsWith(".hdr")) {
            this.name = this.name.substring(0, this.name.length() - 4);
            hdrName = this.name + ".hdr" + suffix;
            imgName = this.name + ".img" + suffix;
        } else {
            hdrName = this.name + suffix;
            imgName = this.name + suffix;
        }
        if (!this.directory.endsWith(File.separator) && !this.directory.equals("")) {
            this.directory = this.directory + File.separator;
        }
        try {
            this.fi = nifti_reader.readHeader(this.directory + hdrName);
            if (this.fi == null) {
                return null;
            }
        }
        catch (IOException e) {
            IJ.log((String)("FileLoader: " + e.getMessage()));
        }
        this.fi.fileName = imgName;
        this.fi.directory = this.directory;
        this.fi.fileFormat = 1;
        return this.fi;
    }

    @Override
    public boolean isZipped() {
        return this.zipped;
    }

    @Override
    public void clearTempFolder() {
        if (this.zipped) {
            FileUtils.deleteFile(this.directory, true);
        }
    }

    @Override
    public String getOrientation() {
        return "As Acquired    ";
    }

    @Override
    public int getOrientationForWriter() {
        return ReaderUtils.getOrientationAsInt(this.getOrientation(), false);
    }

    @Override
    public int getVolumes() {
        if (this.fi != null) {
            return this.fi.nImages;
        }
        return 1;
    }

    public static void main(String[] args) {
        String dir = args[0];
        String name = args[1];
        NiftiReader nr = new NiftiReader(dir, name);
        ImagePlus img = nr.getImagePlus();
        img.show();
    }
}

