/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.nifti;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.nrg.nifti.AffineCoors;
import org.nrg.nifti.CoordinateMapper;
import org.nrg.nifti.NiftiHeader;
import org.nrg.nifti.QuaternCoors;

public class Nifti_Reader
extends ImagePlus
implements PlugIn {
    private boolean littleEndian = false;
    private boolean isNiftiData = false;
    private double cal_min = 0.0;
    private double cal_max = 0.0;
    private int nChannels = 1;
    private int depth = 1;
    private int frames = 1;
    private boolean complex;
    private NiftiHeader nfti_hdr;

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open Nifti...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        IJ.showStatus((String)("Opening: " + directory + name));
        ImagePlus imp = this.load(directory, name);
        if (imp != null) {
            if (this.complex && imp.getStackSize() == 1) {
                imp = this.splitComplexImage(imp);
            }
            this.setStack(imp.getTitle(), imp.getStack());
            this.setFileInfo(imp.getOriginalFileInfo());
            Calibration c = imp.getCalibration();
            boolean isSigned16Bit = c.isSigned16Bit();
            if (isSigned16Bit) {
                isSigned16Bit = this.checkDataRange();
            }
            if (this.nfti_hdr != null) {
                double[] coeff = new double[]{this.nfti_hdr.scl_inter, this.nfti_hdr.scl_slope};
                if (coeff[1] == 0.0) {
                    coeff[1] = 1.0;
                }
                if (isSigned16Bit) {
                    coeff[0] = coeff[0] - 32768.0 * coeff[1];
                }
                c.setFunction(0, coeff, "gray value");
                this.cal_max = (this.cal_max - coeff[0]) / coeff[1];
                this.cal_min = (this.cal_min - coeff[0]) / coeff[1];
            } else {
                if (isSigned16Bit) {
                    this.cal_max += 32768.0;
                    this.cal_min += 32768.0;
                }
                c.disableDensityCalibration();
            }
            if (this.cal_max != this.cal_min) {
                this.getProcessor().setMinAndMax(this.cal_min, this.getType() == 2 ? this.cal_max : this.cal_max - 1.0);
            }
            ImageStack stack = this.getStack();
            if (!this.isNiftiData) {
                for (int i = 1; i <= stack.getSize(); ++i) {
                    ImageProcessor ip2 = stack.getProcessor(i);
                    ip2.flipVertical();
                }
            } else {
                CoordinateMapper[] mp = this.getCoors(this.nfti_hdr);
                if (mp != null) {
                    this.setProperty("coors", mp);
                }
                this.setProperty("nifti", this.nfti_hdr);
            }
            this.setCalibration(c);
            if (this.nChannels * this.depth * this.frames != stack.getSize()) {
                int oldSize = stack.getSize();
                this.nChannels = oldSize / (this.depth * this.frames);
                if (this.nChannels == 0) {
                    this.nChannels = 1;
                    this.frames = oldSize / this.depth;
                    if (this.frames == 0) {
                        this.frames = 1;
                        this.depth = oldSize;
                    }
                }
                for (int i = this.nChannels * this.depth * this.frames; i < oldSize; ++i) {
                    stack.deleteLastSlice();
                }
            }
            this.setDimensions(this.nChannels, this.depth, this.frames);
            if (this.nChannels != 1) {
                this.reshuffleStack(stack.getImageArray(), this.depth * this.frames, stack.getSize());
            }
            if (this.nChannels * this.frames != 1) {
                this.setOpenAsHyperStack(true);
            }
            if (arg.equals("")) {
                this.show();
            }
        }
    }

    public void doPostLoadingActions(ImagePlus imp) {
        if (imp != null) {
            Calibration c;
            boolean isSigned16Bit;
            if (this.complex && imp.getStackSize() == 1) {
                imp = this.splitComplexImage(imp);
            }
            if (isSigned16Bit = (c = imp.getCalibration()).isSigned16Bit()) {
                isSigned16Bit = this.checkDataRange(imp);
            }
            if (this.nfti_hdr != null) {
                double[] coeff = new double[]{this.nfti_hdr.scl_inter, this.nfti_hdr.scl_slope};
                if (coeff[1] == 0.0) {
                    coeff[1] = 1.0;
                }
                if (isSigned16Bit) {
                    coeff[0] = coeff[0] - 32768.0 * coeff[1];
                }
                c.setFunction(0, coeff, "gray value");
                this.cal_max = (this.cal_max - coeff[0]) / coeff[1];
                this.cal_min = (this.cal_min - coeff[0]) / coeff[1];
            } else {
                if (isSigned16Bit) {
                    this.cal_max += 32768.0;
                    this.cal_min += 32768.0;
                }
                c.disableDensityCalibration();
            }
            if (this.cal_max != this.cal_min) {
                this.getProcessor().setMinAndMax(this.cal_min, this.getType() == 2 ? this.cal_max : this.cal_max - 1.0);
            }
            ImageStack stack = this.getStack();
            if (!this.isNiftiData) {
                for (int i = 1; i <= stack.getSize(); ++i) {
                    ImageProcessor ip2 = stack.getProcessor(i);
                    ip2.flipVertical();
                }
            } else {
                CoordinateMapper[] mp = this.getCoors(this.nfti_hdr);
                if (mp != null) {
                    this.setProperty("coors", mp);
                }
                this.setProperty("nifti", this.nfti_hdr);
            }
            this.setCalibration(c);
            if (this.nChannels * this.depth * this.frames != stack.getSize()) {
                int oldSize = stack.getSize();
                this.nChannels = oldSize / (this.depth * this.frames);
                if (this.nChannels == 0) {
                    this.nChannels = 1;
                    this.frames = oldSize / this.depth;
                    if (this.frames == 0) {
                        this.frames = 1;
                        this.depth = oldSize;
                    }
                }
                for (int i = this.nChannels * this.depth * this.frames; i < oldSize; ++i) {
                    stack.deleteLastSlice();
                }
            }
            this.setDimensions(this.nChannels, this.depth, this.frames);
            if (this.nChannels != 1) {
                this.reshuffleStack(stack.getImageArray(), this.depth * this.frames, stack.getSize());
            }
            if (this.nChannels * this.frames != 1) {
                this.setOpenAsHyperStack(true);
            }
        }
    }

    public ImagePlus load(String directory, String name) {
        if (name == null || name == "") {
            return null;
        }
        FileInfo fi = new FileInfo();
        String hdrName = name;
        String imgName = name;
        String suffix = "";
        if (name.endsWith(".gz") || name.endsWith(".GZ")) {
            suffix = name.substring(name.length() - 3);
            name = name.substring(0, name.length() - 3);
        }
        if (name.endsWith(".img") || name.endsWith(".hdr")) {
            name = name.substring(0, name.length() - 4);
            hdrName = name + ".hdr" + suffix;
            imgName = name + ".img" + suffix;
        } else {
            hdrName = name + suffix;
            imgName = name + suffix;
        }
        if (!directory.endsWith(File.separator) && !directory.equals("")) {
            directory = directory + File.separator;
        }
        IJ.showStatus((String)("Reading Header File: " + directory + hdrName));
        try {
            fi = this.readHeader(directory + hdrName);
            if (fi == null) {
                return null;
            }
        }
        catch (IOException e) {
            IJ.log((String)("FileLoader: " + e.getMessage()));
        }
        if (this.isNiftiData) {
            IJ.showStatus((String)("Reading Nifti File: " + directory + imgName));
        } else {
            IJ.showStatus((String)("Reading Analyze File: " + directory + imgName));
        }
        fi.fileName = imgName;
        fi.directory = directory;
        fi.fileFormat = 1;
        FileOpener fo = new FileOpener(fi);
        ImagePlus imp = fo.open(false);
        return imp;
    }

    public FileInfo readHeader(String hdrfile) throws IOException {
        int i;
        FileInputStream filein = new FileInputStream(hdrfile);
        DataInputStream input = null;
        if (hdrfile.endsWith(".gz") || hdrfile.endsWith(".GZ")) {
            GZIPInputStream gzipin = new GZIPInputStream(filein);
            input = new DataInputStream(gzipin);
        } else {
            input = new DataInputStream(filein);
        }
        FileInfo fi = new FileInfo();
        byte[] vunits = new byte[4];
        this.littleEndian = false;
        input.readInt();
        for (i = 0; i < 10; ++i) {
            input.readByte();
        }
        for (i = 0; i < 18; ++i) {
            input.readByte();
        }
        input.readInt();
        input.readShort();
        input.readByte();
        byte dim_info = input.readByte();
        short[] dim = new short[8];
        dim[0] = this.readShort(input);
        if (dim[0] < 0 || dim[0] > 7) {
            this.littleEndian = true;
            fi.intelByteOrder = true;
            dim[0] = (short)(dim[0] >> 8);
        }
        for (i = 1; i < 8; ++i) {
            dim[i] = this.readShort(input);
        }
        fi.width = dim[1];
        fi.height = dim[2];
        int nImages = 1;
        for (i = 3; i <= dim[0]; ++i) {
            nImages *= dim[i];
        }
        fi.nImages = nImages;
        input.read(vunits, 0, 4);
        float intent_p1 = this.littleEndian ? Float.intBitsToFloat((vunits[3] & 0xFF) << 24 | (vunits[2] & 0xFF) << 16 | (vunits[1] & 0xFF) << 8 | vunits[0] & 0xFF) : Float.intBitsToFloat((vunits[0] & 0xFF) << 24 | (vunits[1] & 0xFF) << 16 | (vunits[2] & 0xFF) << 8 | vunits[3] & 0xFF);
        fi.unit = new String(vunits, 0, 4).trim();
        float intent_p2 = this.readFloat(input);
        float intent_p3 = this.readFloat(input);
        short intent_code = this.readShort(input);
        short datatype = this.readShort(input);
        int bitsallocated = this.readShort(input);
        short slice_start = this.readShort(input);
        float[] pixdim = new float[8];
        for (i = 0; i < 8; ++i) {
            pixdim[i] = this.readFloat(input);
        }
        fi.pixelWidth = pixdim[1];
        fi.pixelHeight = pixdim[2];
        fi.pixelDepth = pixdim[3];
        fi.frameInterval = pixdim[4];
        fi.offset = (int)this.readFloat(input);
        float scl_slope = this.readFloat(input);
        float scl_inter = this.readFloat(input);
        short slice_end = this.readShort(input);
        byte slice_code = input.readByte();
        byte xyzt_units = input.readByte();
        this.cal_max = this.readFloat(input);
        this.cal_min = this.readFloat(input);
        float slice_duration = this.readFloat(input);
        float toffset = this.readFloat(input);
        this.readInt(input);
        this.readInt(input);
        byte[] descBuf = new byte[80];
        for (i = 0; i < 80; ++i) {
            descBuf[i] = input.readByte();
        }
        String descrip = new String(descBuf);
        byte[] auxBuf = new byte[24];
        for (i = 0; i < 24; ++i) {
            auxBuf[i] = input.readByte();
        }
        String aux_file = new String(auxBuf);
        short qform_code = this.readShort(input);
        short sform_code = this.readShort(input);
        float quatern_b = this.readFloat(input);
        float quatern_c = this.readFloat(input);
        float quatern_d = this.readFloat(input);
        float qoffset_x = this.readFloat(input);
        float qoffset_y = this.readFloat(input);
        float qoffset_z = this.readFloat(input);
        float[] srow_x = new float[4];
        float[] srow_y = new float[4];
        float[] srow_z = new float[4];
        for (i = 0; i < 4; ++i) {
            srow_x[i] = this.readFloat(input);
        }
        for (i = 0; i < 4; ++i) {
            srow_y[i] = this.readFloat(input);
        }
        for (i = 0; i < 4; ++i) {
            srow_z[i] = this.readFloat(input);
        }
        byte[] intentBuf = new byte[16];
        for (i = 0; i < 16; ++i) {
            intentBuf[i] = input.readByte();
        }
        String intent_name = new String(intentBuf);
        byte[] magicBuf = new byte[4];
        for (i = 0; i < 4; ++i) {
            magicBuf[i] = input.readByte();
        }
        String magic = new String(magicBuf, 0, 3);
        if (magicBuf[3] == 0 && (magic.equals("ni1") || magic.equals("n+1"))) {
            this.isNiftiData = true;
            this.nfti_hdr = new NiftiHeader();
            this.nfti_hdr.dim_info = dim_info;
            this.nfti_hdr.dim = dim;
            this.nfti_hdr.intent_p1 = intent_p1;
            this.nfti_hdr.intent_p2 = intent_p2;
            this.nfti_hdr.intent_p3 = intent_p3;
            this.nfti_hdr.intent_code = intent_code;
            this.nfti_hdr.datatype = datatype;
            this.nfti_hdr.bitpix = (short)bitsallocated;
            this.nfti_hdr.slice_start = slice_start;
            this.nfti_hdr.pixdim = pixdim;
            this.nfti_hdr.vox_offset = fi.offset;
            this.nfti_hdr.scl_slope = scl_slope;
            this.nfti_hdr.scl_inter = scl_inter;
            this.nfti_hdr.slice_end = slice_end;
            this.nfti_hdr.slice_code = slice_code;
            this.nfti_hdr.xyzt_units = xyzt_units;
            this.nfti_hdr.cal_max = (float)this.cal_max;
            this.nfti_hdr.cal_min = (float)this.cal_min;
            this.nfti_hdr.slice_duration = slice_duration;
            this.nfti_hdr.toffset = toffset;
            this.nfti_hdr.glmax = 0;
            this.nfti_hdr.glmin = 0;
            this.nfti_hdr.descrip = descrip;
            this.nfti_hdr.aux_file = aux_file;
            this.nfti_hdr.qform_code = qform_code;
            this.nfti_hdr.sform_code = sform_code;
            this.nfti_hdr.quatern_b = quatern_b;
            this.nfti_hdr.quatern_c = quatern_c;
            this.nfti_hdr.quatern_d = quatern_d;
            this.nfti_hdr.qoffset_x = qoffset_x;
            this.nfti_hdr.qoffset_y = qoffset_y;
            this.nfti_hdr.qoffset_z = qoffset_z;
            this.nfti_hdr.srow_x = srow_x;
            this.nfti_hdr.srow_y = srow_y;
            this.nfti_hdr.srow_z = srow_z;
            this.nfti_hdr.intent_name = intent_name;
        } else {
            this.isNiftiData = false;
        }
        input.close();
        filein.close();
        switch (datatype) {
            case 2: {
                fi.fileType = 0;
                bitsallocated = 8;
                break;
            }
            case 4: {
                fi.fileType = 1;
                bitsallocated = 16;
                break;
            }
            case 8: {
                fi.fileType = 3;
                bitsallocated = 32;
                break;
            }
            case 16: {
                fi.fileType = 4;
                bitsallocated = 32;
                break;
            }
            case 64: {
                fi.fileType = 16;
                bitsallocated = 64;
                break;
            }
            case 128: {
                fi.fileType = 7;
                bitsallocated = 24;
                break;
            }
            case 512: {
                fi.fileType = 2;
                bitsallocated = 16;
                break;
            }
            case 768: {
                fi.fileType = 11;
                bitsallocated = 32;
                break;
            }
            case 32: {
                fi.fileType = 4;
                fi.width *= 2;
                bitsallocated = 32;
                this.complex = true;
                break;
            }
            default: {
                IJ.log((String)("Data type " + datatype + " not supported\n"));
                return null;
            }
        }
        if (dim[0] > 5 && dim[3] * dim[4] * dim[5] != fi.nImages) {
            IJ.log((String)(dim[0] + "-D data not supported\n"));
        } else {
            this.depth = dim[0] < 3 ? 1 : dim[3];
            this.frames = dim[0] < 4 ? 1 : dim[4];
            int n = this.nChannels = dim[0] < 5 ? 1 : dim[5];
        }
        if (this.isNiftiData) {
            int xyz_units = xyzt_units & 7;
            if (xyz_units == 1) {
                fi.unit = "m";
            } else if (xyz_units == 2) {
                fi.unit = "mm";
            } else if (xyz_units == 3) {
                fi.unit = "um";
            }
            int t_units = xyzt_units & 0x18;
            if (t_units == 16) {
                fi.frameInterval *= 0.001;
            } else if (t_units == 24) {
                fi.frameInterval *= 1.0E-6;
            }
        }
        return fi;
    }

    private void reshuffleStack(Object[] stack, int gap, int length) {
        int i;
        Object[] oldStack = new Object[stack.length];
        for (i = 0; i < oldStack.length; ++i) {
            oldStack[i] = stack[i];
        }
        int n = 0;
        for (i = 0; i < gap; ++i) {
            int c = i;
            while (c < length) {
                stack[n] = oldStack[c];
                c += gap;
                ++n;
            }
        }
    }

    private CoordinateMapper[] getCoors(NiftiHeader nfti_hdr) {
        QuaternCoors qmapper = null;
        AffineCoors smapper = null;
        if (nfti_hdr.qform_code != 0) {
            double[] q = new double[5];
            q[0] = nfti_hdr.pixdim[0];
            q[2] = nfti_hdr.quatern_b;
            q[3] = nfti_hdr.quatern_c;
            q[4] = nfti_hdr.quatern_d;
            double[] offset = new double[]{nfti_hdr.qoffset_x, nfti_hdr.qoffset_y, nfti_hdr.qoffset_z};
            double[] pixdim = new double[]{nfti_hdr.pixdim[1], nfti_hdr.pixdim[2], nfti_hdr.pixdim[3]};
            qmapper = new QuaternCoors(q, pixdim, offset, 1, NiftiHeader.getCoorTypeString(nfti_hdr.qform_code));
        }
        if (nfti_hdr.sform_code != 0) {
            double[][] m = new double[3][4];
            for (int i = 0; i < 4; ++i) {
                m[0][i] = nfti_hdr.srow_x[i];
                m[1][i] = nfti_hdr.srow_y[i];
                m[2][i] = nfti_hdr.srow_z[i];
            }
            smapper = new AffineCoors(m, 1, NiftiHeader.getCoorTypeString(nfti_hdr.sform_code));
        }
        if (qmapper == null && smapper == null) {
            return null;
        }
        if (qmapper != null && smapper == null) {
            return new CoordinateMapper[]{qmapper};
        }
        if (qmapper == null && smapper != null) {
            return new CoordinateMapper[]{smapper};
        }
        return new CoordinateMapper[]{qmapper, smapper};
    }

    public boolean checkDataRange() {
        int j;
        short[] pixels;
        int i;
        int min = 65536;
        int max = 0;
        ImageStack s = this.getStack();
        int sliceSize = this.getWidth() * this.getHeight();
        for (i = 1; i <= s.getSize(); ++i) {
            pixels = (short[])s.getProcessor(i).getPixels();
            for (j = 0; j < sliceSize; ++j) {
                min = min < (pixels[j] & 0xFFFF) ? min : pixels[j] & 0xFFFF;
                max = max > (pixels[j] & 0xFFFF) ? max : pixels[j] & 0xFFFF;
            }
        }
        if (min >= 32768) {
            for (i = 1; i <= s.getSize(); ++i) {
                pixels = (short[])s.getProcessor(i).getPixels();
                for (j = 0; j < sliceSize; ++j) {
                    pixels[j] = (short)((pixels[j] & 0xFFFF) - 32768);
                }
            }
            ImageProcessor ip = this.getProcessor();
            ip.setMinAndMax(ip.getMin() - 32768.0, ip.getMax() - 32768.0);
            return false;
        }
        return true;
    }

    public boolean checkDataRange(ImagePlus img) {
        int j;
        short[] pixels;
        int i;
        int min = 65536;
        int max = 0;
        ImageStack s = img.getStack();
        int sliceSize = img.getWidth() * img.getHeight();
        for (i = 1; i <= s.getSize(); ++i) {
            pixels = (short[])s.getProcessor(i).getPixels();
            for (j = 0; j < sliceSize; ++j) {
                min = min < (pixels[j] & 0xFFFF) ? min : pixels[j] & 0xFFFF;
                max = max > (pixels[j] & 0xFFFF) ? max : pixels[j] & 0xFFFF;
            }
        }
        if (min >= 32768) {
            for (i = 1; i <= s.getSize(); ++i) {
                pixels = (short[])s.getProcessor(i).getPixels();
                for (j = 0; j < sliceSize; ++j) {
                    pixels[j] = (short)((pixels[j] & 0xFFFF) - 32768);
                }
            }
            ImageProcessor ip = img.getProcessor();
            ip.setMinAndMax(ip.getMin() - 32768.0, ip.getMax() - 32768.0);
            return false;
        }
        return true;
    }

    ImagePlus splitComplexImage(ImagePlus imp) {
        int w = imp.getWidth();
        int h = imp.getHeight();
        ImageProcessor ip1 = imp.getProcessor();
        ip1.setInterpolationMethod(0);
        ImageProcessor ip2 = ip1.resize(w / 2, h);
        IJ.run((ImagePlus)imp, (String)"Canvas Size...", (String)("width=" + (w + 1) + " height=" + h + " position=Top-Left zero"));
        ip1 = imp.getProcessor();
        ip1.setRoi(1, 0, w, h);
        ImageProcessor ip3 = ip1.resize(w / 2, h);
        ImageStack stack = new ImageStack(w / 2, h);
        stack.addSlice("re", ip2);
        stack.addSlice("im", ip3);
        imp.setStack(null, stack);
        return imp;
    }

    public int readInt(DataInputStream input) throws IOException {
        if (!this.littleEndian) {
            return input.readInt();
        }
        byte b1 = input.readByte();
        byte b2 = input.readByte();
        byte b3 = input.readByte();
        byte b4 = input.readByte();
        return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public short readShort(DataInputStream input) throws IOException {
        if (!this.littleEndian) {
            return input.readShort();
        }
        byte b1 = input.readByte();
        byte b2 = input.readByte();
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public float readFloat(DataInputStream input) throws IOException {
        if (!this.littleEndian) {
            return input.readFloat();
        }
        int orig = this.readInt(input);
        return Float.intBitsToFloat(orig);
    }
}

