/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.nrrd;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.measure.Calibration;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import org.nrg.nrrd.FlexibleFileOpener;
import org.nrg.nrrd.NrrdFileInfo;
import org.nrg.plexiViewer.Reader.ImageReader;
import org.nrg.plexiViewer.Reader.ReaderUtils;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.UnzipFile;

public class NRRDReader
implements ImageReader {
    public final String uint8Types = "uchar, unsigned char, uint8, uint8_t";
    public final String int16Types = "short, short int, signed short, signed short int, int16, int16_t";
    public final String uint16Types = "ushort, unsigned short, unsigned short int, uint16, uint16_t";
    public final String int32Types = "int, signed int, int32, int32_t";
    public final String uint32Types = "uint, unsigned int, uint32, uint32_t";
    private String notes = "";
    private boolean detachedHeader = false;
    private String headerPath = null;
    private String imagePath = null;
    private String imageName = null;
    private String fileName;
    private String directory;
    private NrrdFileInfo fi;
    private Calibration spatialCal;
    private boolean zipped = false;
    private String zext = ".gz";

    public NRRDReader(String dir, String filename) {
        this.directory = dir;
        this.fileName = filename;
    }

    public NRRDReader(String filePath) {
        int i = filePath.lastIndexOf(File.separator);
        if (i != -1) {
            this.directory = filePath.substring(0, i);
            this.fileName = filePath.substring(i + 1);
        } else {
            this.fileName = filePath;
            this.directory = "";
        }
    }

    @Override
    public boolean isZipped() {
        return this.zipped;
    }

    public ImagePlus getImagePlus() {
        ImagePlus imp = this.load();
        if (imp == null) {
            return null;
        }
        if (this.imageName != null) {
            imp.setStack(this.imageName, imp.getStack());
        } else {
            imp.setStack(this.fileName, imp.getStack());
        }
        if (!this.notes.equals("")) {
            imp.setProperty("Info", (Object)this.notes);
        }
        imp.copyScale(imp);
        return imp;
    }

    @Override
    public void clearTempFolder() {
        if (this.zipped) {
            FileUtils.deleteFile(this.directory, true);
        }
    }

    public ImagePlus load() {
        ImagePlus imp;
        if (!this.directory.endsWith(File.separator)) {
            this.directory = this.directory + File.separator;
        }
        if (this.fileName == null || this.fileName == "") {
            return null;
        }
        if (this.fileName.endsWith(this.zext)) {
            this.zipped = true;
        }
        this.unzip();
        try {
            this.getHeaderInfo();
        }
        catch (IOException e) {
            IJ.write((String)("readHeader: " + e.getMessage()));
            return null;
        }
        if (this.fi.encoding.equals("gzip") && this.detachedHeader) {
            FlexibleFileOpener gzfo = new FlexibleFileOpener(this.fi, 1);
            imp = gzfo.open(false);
        } else if (this.fi.encoding.equals("gzip")) {
            long preOffset = this.fi.longOffset > 0L ? this.fi.longOffset : (long)this.fi.offset;
            this.fi.offset = 0;
            this.fi.longOffset = 0L;
            FlexibleFileOpener gzfo = new FlexibleFileOpener(this.fi, 1, preOffset);
            if (IJ.debugMode) {
                IJ.log((String)("gzfo:" + (Object)((Object)gzfo)));
            }
            imp = gzfo.open(false);
        } else {
            FileOpener fo = new FileOpener((FileInfo)this.fi);
            imp = fo.open(false);
        }
        if (imp == null) {
            return null;
        }
        Calibration cal = imp.getCalibration();
        cal.pixelWidth = this.spatialCal.pixelWidth;
        cal.pixelHeight = this.spatialCal.pixelHeight;
        cal.pixelDepth = this.spatialCal.pixelDepth;
        cal.setUnit(this.spatialCal.getUnit());
        cal.xOrigin = this.spatialCal.xOrigin;
        cal.yOrigin = this.spatialCal.yOrigin;
        cal.zOrigin = this.spatialCal.zOrigin;
        imp.setCalibration(cal);
        return imp;
    }

    @Override
    public FileInfo getFileInfo() {
        return this.fi;
    }

    @Override
    public String getOrientation() {
        return "As Acquired    ";
    }

    @Override
    public int getOrientationForWriter() {
        return ReaderUtils.getOrientationAsInt(this.getOrientation(), false);
    }

    @Override
    public int getVolumes() {
        return 1;
    }

    private void unzip() {
        String zext = ".gz";
        if (this.zipped) {
            String suffix = "_" + new Random().nextInt();
            File tempDir = new File(FileUtils.getTempFolder());
            try {
                File dir = File.createTempFile("NRG", suffix, tempDir);
                if (dir.exists()) {
                    dir.delete();
                }
                dir.mkdir();
                new UnzipFile().gunzip(this.directory + File.separator + this.fileName, dir.getPath());
                this.directory = dir.getPath();
            }
            catch (IOException ioe) {
                System.out.println("DicomSequence:: Unable to create temporary directory");
            }
        }
    }

    public NrrdFileInfo getHeaderInfo() throws IOException {
        if (IJ.debugMode) {
            IJ.log((String)"Entering Nrrd_Reader.readHeader():");
        }
        this.fi = new NrrdFileInfo();
        this.fi.directory = this.directory;
        this.fi.fileName = this.fileName;
        this.spatialCal = new Calibration();
        RandomAccessFile input = new RandomAccessFile(this.fi.directory + this.fi.fileName, "r");
        this.fi.fileType = 0;
        this.spatialCal.setUnit("micron");
        this.fi.fileFormat = 1;
        this.fi.nImages = 1;
        while (true) {
            int i;
            String thisLine;
            if ((thisLine = input.readLine()) == null || thisLine.equals("")) {
                if (this.detachedHeader) break;
                this.fi.longOffset = input.getFilePointer();
                break;
            }
            this.notes = this.notes + thisLine + "\n";
            if (thisLine.indexOf("#") == 0) continue;
            String noteType = this.getFieldPart(thisLine, 0).toLowerCase();
            String noteValue = this.getFieldPart(thisLine, 1);
            String noteValuelc = noteValue.toLowerCase();
            String firstNoteValue = this.getSubField(thisLine, 0);
            if (IJ.debugMode) {
                IJ.log((String)("NoteType:" + noteType + ", noteValue:" + noteValue));
            }
            if (noteType.equals("data file") || noteType.equals("datafile")) {
                if (firstNoteValue.equals("LIST")) {
                    throw new IOException("Nrrd_Reader: not yet able to handle datafile: LIST specifications");
                }
                if (!this.getSubField(thisLine, 1).equals("")) {
                    throw new IOException("Nrrd_Reader: not yet able to handle datafile: sprintf file specifications");
                }
                File imageFile = noteValue.indexOf("/") == 0 ? new File(noteValue) : new File(this.fi.directory, noteValue);
                if (imageFile.exists()) {
                    this.fi.directory = imageFile.getParent();
                    this.fi.fileName = imageFile.getName();
                    this.imagePath = imageFile.getPath();
                    this.detachedHeader = true;
                } else {
                    throw new IOException("Unable to find image file =" + imageFile.getPath());
                }
            }
            if (noteType.equals("dimension")) {
                this.fi.dimension = Integer.valueOf(noteValue);
                if (this.fi.dimension > 3) {
                    throw new IOException("Nrrd_Reader: Dimension>3 not yet implemented!");
                }
            }
            if (noteType.equals("sizes")) {
                this.fi.sizes = new int[this.fi.dimension];
                for (int i2 = 0; i2 < this.fi.dimension; ++i2) {
                    this.fi.sizes[i2] = Integer.valueOf(this.getSubField(thisLine, i2));
                    if (i2 == 0) {
                        this.fi.width = this.fi.sizes[0];
                    }
                    if (i2 == 1) {
                        this.fi.height = this.fi.sizes[1];
                    }
                    if (i2 != 2) continue;
                    this.fi.nImages = this.fi.sizes[2];
                }
            }
            if (noteType.equals("units")) {
                this.spatialCal.setUnit(firstNoteValue);
            }
            if (noteType.equals("spacings")) {
                double[] spacings = new double[this.fi.dimension];
                for (i = 0; i < this.fi.dimension; ++i) {
                    spacings[i] = Double.valueOf(this.getSubField(thisLine, i));
                    if (i == 0) {
                        this.spatialCal.pixelWidth = spacings[0];
                    }
                    if (i == 1) {
                        this.spatialCal.pixelHeight = spacings[1];
                    }
                    if (i != 2) continue;
                    this.spatialCal.pixelDepth = spacings[2];
                }
            }
            if (noteType.equals("centers") || noteType.equals("centerings")) {
                this.fi.centers = new String[this.fi.dimension];
                for (int i3 = 0; i3 < this.fi.dimension; ++i3) {
                    this.fi.centers[i3] = this.getSubField(thisLine, i3);
                }
            }
            if (noteType.equals("axis mins") || noteType.equals("axismins")) {
                double[] axismins = new double[this.fi.dimension];
                for (i = 0; i < this.fi.dimension; ++i) {
                    axismins[i] = Double.valueOf(this.getSubField(thisLine, i));
                    if (i == 0) {
                        this.spatialCal.xOrigin = axismins[0];
                    }
                    if (i == 1) {
                        this.spatialCal.yOrigin = axismins[1];
                    }
                    if (i != 2) continue;
                    this.spatialCal.zOrigin = axismins[2];
                }
            }
            if (noteType.equals("type")) {
                if ("uchar, unsigned char, uint8, uint8_t".indexOf(noteValuelc) >= 0) {
                    this.fi.fileType = 0;
                } else if ("ushort, unsigned short, unsigned short int, uint16, uint16_t".indexOf(noteValuelc) >= 0) {
                    this.fi.fileType = 1;
                } else if ("short, short int, signed short, signed short int, int16, int16_t".indexOf(noteValuelc) >= 0) {
                    this.fi.fileType = 2;
                } else if ("uint, unsigned int, uint32, uint32_t".indexOf(noteValuelc) >= 0) {
                    this.fi.fileType = 11;
                } else if ("int, signed int, int32, int32_t".indexOf(noteValuelc) >= 0) {
                    this.fi.fileType = 3;
                } else if (noteValuelc.equals("float")) {
                    this.fi.fileType = 4;
                } else if (noteValuelc.equals("double")) {
                    this.fi.fileType = 16;
                } else {
                    throw new IOException("Unimplemented data type =" + noteValue);
                }
            }
            if (noteType.equals("byte skip") || noteType.equals("byteskip")) {
                this.fi.longOffset = Long.valueOf(noteValue);
            }
            if (noteType.equals("endian")) {
                this.fi.intelByteOrder = noteValuelc.equals("little");
            }
            if (!noteType.equals("encoding")) continue;
            if (noteValuelc.equals("gz")) {
                noteValuelc = "gzip";
            }
            this.fi.encoding = noteValuelc;
        }
        if (this.spatialCal.pixelWidth != 0.0) {
            this.spatialCal.xOrigin /= this.spatialCal.pixelWidth;
        }
        if (this.spatialCal.pixelHeight != 0.0) {
            this.spatialCal.yOrigin /= this.spatialCal.pixelHeight;
        }
        if (this.spatialCal.pixelDepth != 0.0) {
            this.spatialCal.zOrigin /= this.spatialCal.pixelDepth;
        }
        if (this.fi.centers != null) {
            if (this.fi.centers[0].equals("cell")) {
                this.spatialCal.xOrigin -= this.spatialCal.pixelWidth / 2.0;
            }
            if (this.fi.centers[1].equals("cell")) {
                this.spatialCal.yOrigin -= this.spatialCal.pixelHeight / 2.0;
            }
            if (this.fi.dimension > 2 && this.fi.centers[2].equals("cell")) {
                this.spatialCal.zOrigin -= this.spatialCal.pixelDepth / 2.0;
            }
        }
        if (!this.detachedHeader) {
            this.fi.longOffset = input.getFilePointer();
        }
        input.close();
        return this.fi;
    }

    String getFieldPart(String str, int fieldIndex) {
        String[] fieldParts = (str = str.trim()).split(":\\s+");
        if (fieldParts.length < 2) {
            return fieldParts[0];
        }
        if (fieldIndex == 0) {
            return fieldParts[0];
        }
        return fieldParts[1];
    }

    String getSubField(String str, int fieldIndex) {
        String[] fields_values;
        String fieldDescriptor = this.getFieldPart(str, 1);
        fieldDescriptor = fieldDescriptor.trim();
        if (IJ.debugMode) {
            IJ.log((String)("fieldDescriptor = " + fieldDescriptor + "; fieldIndex = " + fieldIndex));
        }
        if (fieldIndex >= (fields_values = fieldDescriptor.split("\\s+")).length) {
            return "";
        }
        String rval = fields_values[fieldIndex];
        if (rval.startsWith("\"")) {
            rval = rval.substring(1);
        }
        if (rval.endsWith("\"")) {
            rval = rval.substring(0, rval.length() - 1);
        }
        return rval;
    }
}

