/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Reader;

import ij.io.FileInfo;
import ij.process.ByteProcessor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class AnalyzeObjectMapReader {
    String objMap;
    FileInfo fi;
    boolean littleEndian = false;
    int numberOfObjects = -1;
    String[] objNames;

    public AnalyzeObjectMapReader(String objmapFile) {
        this.objMap = objmapFile;
        if (!this.objMap.endsWith(".obj")) {
            this.objMap = this.objMap + ".obj";
        }
        this.fi = new FileInfo();
        this.parseObjMap(false, null);
    }

    private void parseObjMap(boolean createImageFiles, String outdirectory) {
        try {
            FileInputStream filein = new FileInputStream(this.objMap);
            DataInputStream input = new DataInputStream(filein);
            input.readInt();
            this.fi.width = input.readInt();
            this.fi.height = input.readInt();
            this.fi.nImages = input.readInt();
            this.numberOfObjects = input.readInt();
            this.objNames = new String[this.numberOfObjects];
            for (int i = 0; i < this.numberOfObjects; ++i) {
                int j;
                byte[] b = new byte[152];
                input.read(b);
                for (j = 0; j < b.length && (char)b[j] != '\u0000'; ++j) {
                }
                String objName = new String(b, 0, j);
                String[] parts = objName.split("\\.");
                if (parts.length == 1) {
                    this.objNames[i] = parts[0];
                    continue;
                }
                this.objNames[Integer.parseInt((String)parts[0])] = parts[1];
            }
            try {
                input.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            filein.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getRegionLabels() {
        return this.objNames;
    }

    public int getNoOfRegions() {
        return this.objNames.length;
    }

    public FileInfo getFileInfo() {
        return this.fi;
    }

    private boolean createAnalyzeImageFile(DataInputStream input, String outdirectory) throws IOException {
        int indexOfDot;
        boolean failed = true;
        int indexOfSlash = this.objMap.lastIndexOf(File.separator);
        String rootName = this.objMap;
        if (indexOfSlash != -1) {
            rootName = this.objMap.substring(indexOfSlash + 1);
        }
        if ((indexOfDot = rootName.lastIndexOf(".")) != -1) {
            rootName = rootName.substring(0, indexOfDot);
        }
        ArrayList<Byte> values = new ArrayList<Byte>();
        ArrayList<Integer> length = new ArrayList<Integer>();
        int i = 1;
        boolean insert = false;
        int cnt = 0;
        while (input.available() != 0) {
            Byte mByte = new Byte(input.readByte());
            int value = AnalyzeObjectMapReader.unsignedByteToInt(mByte);
            if (i == 1) {
                if (value > 0) {
                    length.add(new Integer(value));
                    i = 0;
                    insert = true;
                    continue;
                }
                ++cnt;
                continue;
            }
            if (insert) {
                values.add(mByte);
                insert = false;
            }
            i = 1;
        }
        System.out.println("Skipped " + cnt + " Picked " + length.size() + " " + length.size());
        int[] lengthCummulativeSum = this.cummulativeSum(length);
        int[] lengthTemp = new int[lengthCummulativeSum[lengthCummulativeSum.length - 1]];
        for (i = 0; i < lengthTemp.length; ++i) {
            lengthTemp[i] = i == 0 ? 1 : 0;
        }
        for (i = 0; i < lengthCummulativeSum.length - 1; ++i) {
            int n = i;
            lengthCummulativeSum[n] = lengthCummulativeSum[n] + 1;
            lengthTemp[lengthCummulativeSum[i] - 1] = 1;
        }
        lengthCummulativeSum = this.cummulativeSum(lengthTemp);
        byte[] valueArray = new byte[lengthCummulativeSum.length];
        for (i = 0; i < lengthCummulativeSum.length; ++i) {
            valueArray[i] = (Byte)values.get(lengthCummulativeSum[i] - 1);
            System.out.print(valueArray[i]);
        }
        System.out.println("Pixels length " + valueArray.length);
        ByteProcessor ip = new ByteProcessor(this.fi.width, this.fi.height, valueArray, (ColorModel)this.getDefaultColorModel());
        return !failed;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private int[] cummulativeSum(ArrayList array) {
        if (array == null || array.size() == 0) {
            return null;
        }
        int[] arrayToInt = new int[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            arrayToInt[i] = (Integer)array.get(i);
        }
        return this.cummulativeSum(arrayToInt);
    }

    private int[] cummulativeSum(int[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        int[] rtn = new int[array.length];
        rtn[0] = array[0];
        for (int i = 1; i < array.length; ++i) {
            rtn[i] = 0;
            for (int j = 0; j <= i; ++j) {
                int n = i;
                rtn[n] = rtn[n] + array[j];
            }
        }
        return rtn;
    }

    private void print(int[] obj) {
        for (int i = 0; i < obj.length; ++i) {
            System.out.print(obj[i] + " ");
        }
        System.out.println("******");
    }

    private int[] decodeRLE(int[] array) {
        int count = 0;
        int i = 0;
        int RLE_ESCAPE = Integer.MIN_VALUE;
        while (i < array.length) {
            if (array[i] == Integer.MIN_VALUE) {
                count += array[i + 2];
                i += 3;
                continue;
            }
            ++count;
            ++i;
        }
        int[] decoded = new int[count];
        int p = 0;
        for (i = 0; i < array.length; ++i) {
            int q = array[i];
            if (q == Integer.MIN_VALUE) {
                int val = array[++i];
                int cnt = array[++i];
                for (int z = 0; z < cnt; ++z) {
                    decoded[p++] = val;
                }
                continue;
            }
            decoded[p++] = q;
        }
        return decoded;
    }

    public IndexColorModel getDefaultColorModel() {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            r[i] = (byte)i;
            g[i] = (byte)i;
            b[i] = (byte)i;
        }
        return new IndexColorModel(8, 256, r, g, b);
    }

    public static void main(String[] args) {
        AnalyzeObjectMapReader objReader = new AnalyzeObjectMapReader("Y:\\data2\\WORK\\PIPELINE_TEST\\jc_roi\\jc_cerebellum_mr_1.obj");
        String[] regions = objReader.getRegionLabels();
        for (int i = 0; i < regions.length; ++i) {
            System.out.println("Obj Lable " + i + " " + regions[i]);
        }
    }
}

