/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Reader;

import ij.io.FileInfo;
import java.io.File;
import java.io.IOException;
import org.nrg.plexiViewer.Reader.ImageReader;
import org.nrg.plexiViewer.Reader.ImageReaderPreparer;
import org.nrg.plexiViewer.utils.FileUtils;

public class GIFReader
extends ImageReaderPreparer
implements ImageReader {
    String directory;
    String fileName;

    public GIFReader(String directory, String fileName) {
        this.directory = directory;
        this.fileName = fileName;
    }

    @Override
    public boolean isZipped() {
        return this.zipped;
    }

    @Override
    public void clearTempFolder() {
        if (this.zipped) {
            FileUtils.deleteFile(this.directory, true);
        }
    }

    @Override
    public FileInfo getFileInfo() throws IOException {
        FileInfo fi = null;
        String path = "";
        String name = "";
        name = this.fileName.endsWith(".gif") ? this.fileName.substring(0, this.fileName.length() - 4) : (this.fileName.endsWith(".GIF") ? this.fileName.substring(0, this.fileName.length() - 4) : this.fileName);
        String destDir = this.unzip(this.directory, this.fileName);
        if (this.zipped) {
            this.directory = destDir;
        }
        if (this.directory != null && !this.directory.equals("")) {
            if (!this.directory.endsWith("" + File.separatorChar)) {
                this.directory = this.directory + File.separatorChar;
            }
        } else {
            System.out.println("GIFReader:: Directory string is empty or null\n");
            throw new IOException();
        }
        fi = new FileInfo();
        fi.fileFormat = 3;
        fi.fileName = name + ".gif";
        fi.directory = this.directory;
        return fi;
    }

    @Override
    public String getOrientation() {
        return null;
    }

    @Override
    public int getOrientationForWriter() {
        return -1;
    }

    @Override
    public int getVolumes() {
        return 0;
    }
}

