/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Reader;

import ij.io.FileInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.nrg.plexiViewer.Reader.FileScanner;
import org.nrg.plexiViewer.Reader.ImageReader;
import org.nrg.plexiViewer.Reader.ImageReaderPreparer;
import org.nrg.plexiViewer.Reader.ReaderUtils;
import org.nrg.plexiViewer.utils.FileUtils;

public class IFHReader
extends ImageReaderPreparer
implements ImageReader {
    String directory;
    String fileName;
    private String orientation;
    int volumes = 1;

    public IFHReader(String directory, String fileName) {
        this.directory = directory;
        this.fileName = fileName;
        this.orientation = null;
    }

    @Override
    public boolean isZipped() {
        return this.zipped;
    }

    @Override
    public void clearTempFolder() {
        if (this.zipped) {
            FileUtils.deleteFile(this.directory, true);
        }
    }

    @Override
    public FileInfo getFileInfo() throws IOException {
        FileInfo fi = null;
        String path = "";
        try {
            String name = "";
            name = this.fileName.endsWith(".img") ? this.fileName.substring(0, this.fileName.length() - 4) : (this.fileName.endsWith(".ifh") ? this.fileName.substring(0, this.fileName.length() - 4) : this.fileName);
            String destDir = this.unzip(this.directory, this.fileName);
            if (this.zipped) {
                this.directory = destDir;
            }
            if (this.directory != null && !this.directory.equals("")) {
                if (!this.directory.endsWith("" + File.separatorChar)) {
                    this.directory = this.directory + File.separatorChar;
                }
            } else {
                System.out.println("IFHReader:: Directory string is empty or null\n");
                return fi;
            }
            path = path + this.directory + name + ".ifh";
            fi = new FileInfo();
            fi.unit = "pixels";
            fi.fileFormat = 1;
            FileScanner fscanner = new FileScanner(path);
            fscanner.open();
            this.orientation = fscanner.getDelimitedString("orientation", ":=");
            fi.intelByteOrder = fscanner.getDelimitedString("imagedata byte order", ":=") != null && fscanner.getDelimitedString("imagedata byte order", ":=").equalsIgnoreCase("LITTLEENDIAN");
            fi.width = Integer.parseInt(fscanner.getDelimitedString("matrix size [1]", ":="));
            fi.height = Integer.parseInt(fscanner.getDelimitedString("matrix size [2]", ":="));
            fi.nImages = Integer.parseInt(fscanner.getDelimitedString("matrix size [3]", ":="));
            this.volumes = Integer.parseInt(fscanner.getDelimitedString("matrix size [4]", ":="));
            fi.pixelWidth = Double.parseDouble(fscanner.getDelimitedString("scaling factor (mm/pixel) [1]", ":="));
            fi.pixelHeight = Double.parseDouble(fscanner.getDelimitedString("scaling factor (mm/pixel) [2]", ":="));
            fi.pixelDepth = Double.parseDouble(fscanner.getDelimitedString("scaling factor (mm/pixel) [3]", ":="));
            fi.unit = "mm";
            String bPerPixel = fscanner.getDelimitedString("number of bytes per pixel", ":=");
            if (bPerPixel != null) {
                fi.fileType = Integer.parseInt(bPerPixel) == 4 ? 4 : (Integer.parseInt(bPerPixel) == 1 ? 0 : 0);
            }
            fi.fileName = name + ".img";
            fi.directory = this.directory;
            fscanner.close();
        }
        catch (FileNotFoundException fne) {
            System.out.println(fne.getMessage());
            System.out.println("Didnt find the file at path " + path + "\n");
            return null;
        }
        return fi;
    }

    public String toString() {
        return "Directory: " + this.directory + "\t Filename: " + this.fileName + " ";
    }

    @Override
    public int getVolumes() {
        return this.volumes;
    }

    @Override
    public String getOrientation() {
        return ReaderUtils.getOrientationLabel(this.orientation);
    }

    @Override
    public int getOrientationForWriter() {
        return ReaderUtils.getOrientationAsInt(this.getOrientation(), false);
    }
}

