/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Reader;

import ij.io.FileInfo;
import java.io.IOException;
import org.nrg.nifti.NiftiReader;
import org.nrg.nrrd.NRRDReader;
import org.nrg.plexiViewer.Reader.AnalyzeReader;
import org.nrg.plexiViewer.Reader.DICOMReader;
import org.nrg.plexiViewer.Reader.GIFReader;
import org.nrg.plexiViewer.Reader.IFHReader;
import org.nrg.plexiViewer.Reader.ImageReader;

public class PlexiImageHeaderReader {
    String type;
    String orientation;
    ImageReader imgReader = null;

    public PlexiImageHeaderReader(String type) {
        this.type = type;
    }

    public FileInfo getFileInfo(String directory, String fileName) throws IOException {
        if (this.type.startsWith("ANALYZE")) {
            this.imgReader = new AnalyzeReader(directory, fileName);
        } else if (this.type.equalsIgnoreCase("IFH")) {
            this.imgReader = new IFHReader(directory, fileName);
        } else if (this.type.equalsIgnoreCase("DICOM")) {
            this.imgReader = new DICOMReader(directory, fileName);
        } else if (this.type.equalsIgnoreCase("GIF")) {
            this.imgReader = new GIFReader(directory, fileName);
        } else if (this.type.equalsIgnoreCase("NRRD")) {
            this.imgReader = new NRRDReader(directory, fileName);
        } else if (this.type.equalsIgnoreCase("NIFTI")) {
            this.imgReader = new NiftiReader(directory, fileName);
        } else {
            System.out.println("Do not know how to read image file type " + this.type + "\n");
            return null;
        }
        return this.imgReader.getFileInfo();
    }

    public void clearTempFolder() {
        this.imgReader.clearTempFolder();
    }

    public String getOrientation() {
        this.orientation = null;
        if (this.imgReader != null) {
            this.orientation = this.imgReader.getOrientation();
        } else {
            System.out.println("PlexiImageHeaderReader::ImgReader is blank");
        }
        return this.orientation;
    }

    public int getVolumes() {
        int rtn = 0;
        if (this.imgReader != null) {
            return this.imgReader.getVolumes();
        }
        return rtn;
    }

    public int getOrientationForWriter() {
        int orientation = -1;
        if (this.imgReader != null) {
            orientation = this.imgReader.getOrientationForWriter();
        } else {
            System.out.println("PlexiImageHeaderReader::ImgReader is blank");
        }
        return orientation;
    }

    public boolean isGIF_JPG_Others() {
        boolean rtn = false;
        if (this.type.equalsIgnoreCase("GIF")) {
            rtn = true;
        }
        return rtn;
    }
}

