/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.Writer;

import ij.measure.Calibration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.nrg.plexiViewer.Reader.ReaderUtils;

public class IFHWriter {
    public void writeHeader(String file, String orientation, String bytes, Calibration cal, int width, int height, int depth) {
        String name = "";
        name = file.endsWith(".img") ? file.substring(0, file.length() - 4) : (file.endsWith(".ifh") ? file.substring(0, file.length() - 4) : file);
        File out = new File(name + ".ifh");
        if (out == null) {
            System.out.println("Couldn't open header file: " + file);
            return;
        }
        try {
            FileWriter writer = new FileWriter(out);
            writer.write("INTERFILE\t\t\t:=\n");
            writer.write("version of keys\t\t\t:= 3.3\n");
            writer.write("number format\t\t\t:= " + ReaderUtils.getNumberFormat(bytes) + "\n");
            writer.write("number of bytes per pixel\t:= " + bytes + "\n");
            writer.write("orientation\t\t\t:= " + ReaderUtils.getOrientationAsInt(orientation, false) + "\n");
            writer.write("number of dimensions\t\t:= 4\n");
            writer.write("matrix size [1]\t\t\t:= " + width + "\n");
            writer.write("matrix size [2]\t\t\t:= " + height + "\n");
            writer.write("matrix size [3]\t\t\t:= " + depth + "\n");
            writer.write("matrix size [4]\t\t\t:= 1\n");
            writer.write("scaling factor (mm/pixel) [1]\t:= " + cal.pixelWidth + "\n");
            writer.write("scaling factor (mm/pixel) [2]\t:= " + cal.pixelHeight + "\n");
            writer.write("scaling factor (mm/pixel) [3]\t:= " + cal.pixelDepth + "\n");
            writer.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

