/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.apps;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.nrg.plexiViewer.converter.ConverterUtils;
import org.nrg.plexiViewer.converter.NonXnatConverter;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.xml.LoRes;
import org.nrg.plexiViewer.lite.xml.ViewableItem;
import org.nrg.plexiViewer.manager.PlexiSpecDocReader;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.xdat.XDAT;
import org.nrg.xdat.security.ElementSecurity;
import org.nrg.xft.exception.XFTInitException;
import org.nrg.xft.schema.XFTManager;

public class PlexiConverter {
    Hashtable inputArgsHash;
    String sessionListFile = null;
    boolean debug = false;
    boolean all = false;
    String session = null;
    String xnatSchemaLocation = null;
    boolean overwrite = false;
    boolean radiologic = false;
    float minIntensity = -1.0f;
    float maxIntensity = -1.0f;
    boolean onlyThumbnail = false;

    public PlexiConverter(String[] args) {
        if (args.length < 1 || args.length > 14) {
            this.showUsage();
            return;
        }
        this.inputArgsHash = new Hashtable();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-all")) {
                this.all = true;
            } else if (args[i].equalsIgnoreCase("-file")) {
                if (i + 1 < args.length) {
                    this.sessionListFile = args[i + 1];
                }
            } else if (args[i].equalsIgnoreCase("-session") && i + 1 < args.length) {
                this.session = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-thumbnail")) {
                this.onlyThumbnail = true;
            }
            if (args[i].equalsIgnoreCase("-o")) {
                this.overwrite = true;
            }
            if (args[i].equalsIgnoreCase("-r")) {
                this.radiologic = true;
            }
            if (args[i].equalsIgnoreCase("-x")) {
                this.xnatSchemaLocation = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-minIntensity") && i + 1 < args.length) {
                this.minIntensity = Float.parseFloat(args[i + 1]);
            }
            if (args[i].equalsIgnoreCase("-maxIntensity") && i + 1 < args.length) {
                this.maxIntensity = Float.parseFloat(args[i + 1]);
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
            }
            if (!args[i].equalsIgnoreCase("-version")) continue;
            Package p = this.getClass().getPackage();
            System.out.println("PlexiConverter Implementation Version : " + p.getImplementationVersion());
            System.exit(1);
        }
    }

    public int create() {
        int exitStatus = 1;
        if (this.xnatSchemaLocation == null) {
            System.out.println("Will try the standalone mode");
            if (this.sessionListFile == null) {
                System.out.println("Unable to proceed....missing file info");
                exitStatus = 1;
                return exitStatus;
            }
            this.parseFileAndCallConverter(this.sessionListFile);
            return exitStatus;
        }
        try {
            XFTManager.GetInstance();
        }
        catch (XFTInitException xftInitE) {
            try {
                XDAT.init((String)this.xnatSchemaLocation);
            }
            catch (Exception e) {
                exitStatus = 1;
                e.printStackTrace();
                return exitStatus;
            }
        }
        try {
            if (this.all) {
                this.createForAllSessions();
            } else if (this.sessionListFile != null) {
                exitStatus = this.createForSessionsInList();
            } else if (this.session != null) {
                exitStatus = this.createForSession();
            }
        }
        catch (Exception e) {
            exitStatus = 1;
            e.printStackTrace();
        }
        return exitStatus;
    }

    void parseFileAndCallConverter(String sessionFile) {
        ArrayList list = FileUtils.parseFile(this.sessionListFile);
        for (String lineInFile : list) {
            String[] lineCols = lineInFile.split("#");
            String fromPath = lineCols[0];
            String fromFile = lineCols[1];
            String toPath = lineCols[2];
            String format = lineCols[3];
            String outOrientation = lineCols[4];
            int sliceNo = Integer.parseInt(lineCols[5]);
            NonXnatConverter converter = new NonXnatConverter(fromPath, fromFile, toPath);
            converter.setFormat(format);
            if (this.minIntensity != -1.0f && this.maxIntensity != -1.0f) {
                converter.setMinIntensity(this.minIntensity);
                converter.setMaxIntensity(this.maxIntensity);
            }
            converter.createThumbnail(outOrientation, sliceNo);
        }
    }

    private void createForAllSessions() {
        try {
            Hashtable list = ElementSecurity.GetDistinctIdValuesFor((String)"xnat:mrSessionData", (String)"xnat:mrSessionData.ID", null);
            Enumeration e = list.elements();
            while (e.hasMoreElements()) {
                this.convert((String)e.nextElement());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int createForSessionsInList() {
        int exitStatus = 0;
        try {
            ArrayList list = FileUtils.parseFile(this.sessionListFile);
            Iterator iter = list.iterator();
            while (iter.hasNext() && (exitStatus = this.convert((String)iter.next())) == 0) {
            }
            return exitStatus;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private int createForSession() {
        try {
            return this.convert(this.session);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private int convert(String sessionId) {
        int exitStatus = 0;
        return exitStatus;
    }

    private int createLoRes(UserSelection opts) {
        int rtn = 0;
        UserSelection opt = (UserSelection)opts.clone();
        ViewableItem vi = PlexiSpecDocReader.GetInstance().getSpecDoc(opts.getProject()).getViewableItem(opt.getDataType());
        if (vi.getLoResHash() != null && vi.getLoResHash().size() > 0) {
            if (opt.getLoResType() == null) {
                if (vi.getLoResHash().size() == 1) {
                    Object uniqueKey = vi.getLoResHash().keys().nextElement();
                    opt.setLoResType(((LoRes)vi.getLoResHash().get(uniqueKey)).getType());
                } else {
                    opt.setLoResType(PlexiSpecDocReader.GetInstance().getSpecDoc(opts.getProject()).getDefaultLoResType());
                }
            }
            PlexiImageFile pf = new PlexiImageFile();
            PlexiImageFile hpf = opt.hasFile() ? opt.getFile() : FileUtils.getHiResFilePath(opt.getSessionId(), opt.getProject(), opt.getDataType(), opt.getHiResLayerNum(), opt.getScanNo());
            if (hpf == null) {
                System.out.println("Pf is null!! " + opt);
                return 2;
            }
            opt.setFile(hpf);
            pf = ConverterUtils.convert(opt);
            this.logBuild("LoRes " + opt.getLoResType(), pf == null ? 1 : 0, opt.getSessionId());
            if (pf == null) {
                System.out.println("Couldnt launch the conveter");
                return 3;
            }
        } else {
            System.out.println("No Low Resolution node found in the PlexiViewerSpec.xml");
        }
        return rtn;
    }

    private int createThumbnail(UserSelection opts) {
        System.out.println("PlexiConverter.java::createThumbnail()");
        System.out.println(" Arguments passed:");
        System.out.println("  1) UserSelection: sessionID=" + opts.getSessionId() + "  dataType=" + opts.getDataType() + "  HiResLayerNum=" + opts.getHiResLayerNum() + "  scanNo=" + opts.getScanNo() + "  display=" + opts.getDisplay() + "  exptType=" + opts.getProject() + "  ");
        int rtn = 0;
        UserSelection opt = (UserSelection)opts.clone();
        ViewableItem vi = PlexiSpecDocReader.GetInstance().getSpecDoc(opt.getProject()).getViewableItem(opt.getDataType());
        System.out.println("PlexiConverter.java::createThumbnail()");
        System.out.println(" ViewableItem:  HiResFromat=" + vi.getHiRes().getFormat() + "  convertToformat=" + vi.getThumbnail().getFormat() + "  Slices=" + vi.getThumbnail().getSlices().toString());
        if (vi.getThumbnail() != null) {
            PlexiImageFile pf = new PlexiImageFile();
            PlexiImageFile hpf = opt.hasFile() ? opt.getFile() : FileUtils.getHiResFilePath(opt.getSessionId(), opt.getProject(), opt.getDataType(), opt.getHiResLayerNum(), opt.getScanNo());
            if (hpf == null) {
                System.out.println("Pf is null!! " + opt);
                return 2;
            }
            System.out.println("PlexiConverter.java::createThumbnail() - Setting HiResFilePath to " + hpf.getPath());
            opt.setFile(hpf);
            System.out.println("PlexiConverter.java::createThumbnail() - Calling ConverterUtils.convert()");
            pf = ConverterUtils.convert(opt);
            System.out.println("PlexiConverter.java::createThumbnail() - Done.");
            this.logBuild("Thumbnail ", pf == null ? 1 : 0, opt.getSessionId());
            if (pf == null) {
                System.out.println("Couldnt launch the thumbnail converter");
                return 3;
            }
        } else {
            System.out.println("No Thumbnail Node found in the PlexiViewerSpec.xml file");
        }
        return rtn;
    }

    private void logBuild(String buildType, int exitStatus, String sessionId) {
        if (exitStatus == 0) {
            System.out.println("Built " + buildType + " for " + sessionId);
        } else {
            System.out.println("Couldnt Build " + buildType + " for " + sessionId);
        }
    }

    private void showError(String msg) {
        System.out.println(msg);
        System.exit(1);
    }

    private void showUsage() {
        System.out.println(this.getUsage());
    }

    String getUsage() {
        String usage = "Usage: plexiConverter -all [-file <path to file containing session ids>] [-session <session id>] \n";
        usage = usage + "-o <overwrite existing files [Default: false]>\n -r <radiologic convention [Default non-radiologic]>\n";
        usage = usage + "-x <path to XNAT project>\n";
        usage = usage + "-minIntensity <min intensity> [used only with -file]\n";
        usage = usage + "-maxIntensity <max intensity> [used only with -file]\n";
        usage = usage + "-thumbnail [this option will result in only thumbnail files being generated\n";
        usage = usage + "If -x flag is not passed, the file passed should have # separated information\n";
        usage = usage + "<path to file>#<name of input file>#<path to write to>#<Image Format>#<orientation>#<slice no>\n";
        return usage;
    }

    public static void main(String[] args) {
        try {
            int status = new PlexiConverter(args).create();
            System.exit(status);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

