/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.converter;

import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.measure.Calibration;
import ij.process.StackConverter;
import java.io.File;
import java.util.Enumeration;
import org.nrg.plexiViewer.Writer.AnalyzeWriter;
import org.nrg.plexiViewer.converter.plexiLoResConverterI;
import org.nrg.plexiViewer.io.PlexiFileOpener;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.xml.HiRes;
import org.nrg.plexiViewer.lite.xml.LoRes;
import org.nrg.plexiViewer.lite.xml.ViewableItem;
import org.nrg.plexiViewer.manager.PlexiSpecDocReader;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.Transform.PlexiImageOrientor;
import org.nrg.plexiViewer.utils.Transform.TransformationTools;

public class Analyze8BITConverter
implements plexiLoResConverterI {
    HiRes hRes;
    LoRes lRes;
    UserSelection options;
    FileInfo fi;
    String fromFileName;
    String toFileName;
    String fromPath;
    String toPath;
    String cachePath;
    String baseOrientation;
    double minIntensity;
    double maxIntensity;
    boolean single = false;
    ViewableItem viewableItem;

    public Analyze8BITConverter(UserSelection options) {
        this.options = options;
        this.viewableItem = PlexiSpecDocReader.GetInstance().getSpecDoc(options.getProject()).getViewableItem(options.getDataType());
        this.hRes = this.viewableItem.getHiRes();
        this.lRes = this.viewableItem.getLoRes(options.getLoResType());
    }

    public int convert() {
        if (this.options.hasFile() || this.options.getOrientation() != null) {
            this.single = true;
        }
        System.out.println("Create for a single file: " + this.single);
        return this.doConvert();
    }

    private ImagePlus getImage(Integer layerNum) {
        String sessionId = this.options.getSessionId();
        String scanNo = this.options.getScanNo();
        PlexiImageFile pf = FileUtils.getHiResFilePath(sessionId, this.options.getProject(), this.options.getDataType(), layerNum, this.options.getScanNo());
        this.fromPath = pf.getPath();
        this.fromFileName = pf.getName();
        System.out.println("From File Name is " + this.fromFileName);
        this.cachePath = pf.getCachePath();
        ImagePlus image = this.openBaseFile();
        if (image == null) {
            // empty if block
        }
        if (image == null) {
            image = this.openBaseFile();
        }
        if (image == null) {
            System.out.println("Couldnt create HiRes image...Exiting\n");
            return null;
        }
        return image;
    }

    private ImagePlus getImage() {
        String sessionId = this.options.getSessionId();
        String scanNo = this.options.getScanNo();
        PlexiImageFile pf = FileUtils.getHiResFilePath(sessionId, this.options.getProject(), this.options.getDataType(), this.options.getHiResLayerNum(), this.options.getScanNo());
        this.fromPath = pf.getPath();
        this.fromFileName = pf.getName();
        this.cachePath = pf.getCachePath();
        ImagePlus image = this.openBaseFile();
        if (image == null) {
            // empty if block
        }
        if (image == null) {
            image = this.openBaseFile();
        }
        if (image == null) {
            System.out.println("Couldnt create HiRes image...Exiting\n");
            return null;
        }
        return image;
    }

    private void setNamesAndCreate8Bit(ImagePlus image) {
        this.toFileName = FileUtils.getLoResFileName(this.fromFileName, this.options.getLoResType(), this.options.getOrientation());
        this.toPath = PlexiSpecDocReader.GetInstance().getSpecDoc(this.options.getProject()).getLoResArchiveLocation(this.options.getSessionId());
        if (!FileUtils.fileExists(this.toPath, this.toFileName) || this.options.canOverwrite()) {
            ImagePlus adjust = new ImagePlus();
            adjust.setCalibration(image.getCalibration());
            adjust.setStack("", image.getStack());
            this.doPerform(adjust);
        } else {
            System.out.println("File already exists" + this.toPath + File.separator + this.toFileName);
        }
    }

    private int doConvert() {
        String sessionId = this.options.getSessionId();
        int status = 0;
        if (this.single) {
            ImagePlus image = this.getImage();
            this.setNamesAndCreate8Bit(image);
        } else {
            Enumeration e = this.hRes.getLayersHash().keys();
            while (e.hasMoreElements()) {
                Integer layerNum = (Integer)e.nextElement();
                ImagePlus image = this.getImage(layerNum);
                String oldOri = this.options.getOrientation();
                this.options.setOrientation("Transverse");
                this.setNamesAndCreate8Bit(image);
                this.options.setOrientation("Coronal");
                this.setNamesAndCreate8Bit(image);
                this.options.setOrientation("Sagittal");
                this.setNamesAndCreate8Bit(image);
                this.options.setOrientation(oldOri);
            }
        }
        System.gc();
        return status;
    }

    private ImagePlus openBaseFile() {
        PlexiImageFile pf = new PlexiImageFile();
        pf.setPath(this.fromFileName);
        pf.setPath(this.fromPath);
        pf.setXsiType("plexi:imageResource");
        PlexiFileOpener pfo = new PlexiFileOpener(this.viewableItem.getHiRes().getFormat(), pf);
        ImagePlus image = pfo.getImagePlus();
        if (image == null) {
            System.out.println("Image Converter....couldnt find the  Image File");
            return null;
        }
        if (pfo.getFileInfo().fileType != 0) {
            new StackConverter(image).convertToGray8();
        }
        this.baseOrientation = pfo.getOrientation();
        return image;
    }

    private int doPerform(ImagePlus img) {
        try {
            if (this.lRes.getCropDetails().deleteSlices()) {
                img = TransformationTools.dropSlices(img, this.lRes.getCropDetails().getStartSlice(), this.lRes.getCropDetails().getEndSlice());
            }
            if (this.lRes.getCropDetails().crop()) {
                img = TransformationTools.crop(img, this.lRes.getCropDetails().getBoundingRectangle());
            }
            img = new PlexiImageOrientor(img).getImage(this.baseOrientation, this.options.getOrientation() + "F");
            if (!FileUtils.dirExists(this.toPath)) {
                FileUtils.createDirectory(this.toPath);
            }
            new FileSaver(img).saveAsRawStack(this.toPath + File.separator + this.toFileName);
            img.setFileInfo(this.getFileInfo(img.getCalibration(), img.getWidth(), img.getHeight(), img.getStackSize()));
            new AnalyzeWriter().save(img, this.toPath, this.toFileName, this.options.getOrientation() + "F");
            return 0;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return -1;
        }
    }

    @Override
    public PlexiImageFile getFileLocationAndName() {
        PlexiImageFile pf = new PlexiImageFile();
        pf.setName(this.toFileName);
        pf.setPath(this.toPath);
        pf.setCachePath(this.cachePath);
        return pf;
    }

    private FileInfo getFileInfo(Calibration cal, int w, int h, int s) {
        FileInfo fi = new FileInfo();
        fi.fileType = 0;
        fi.width = w;
        fi.height = h;
        fi.nImages = s;
        fi.pixelWidth = cal.pixelWidth;
        fi.pixelHeight = cal.pixelHeight;
        fi.pixelDepth = cal.pixelDepth;
        return fi;
    }

    @Override
    public int convertAndSave(UserSelection u) {
        this.options = u;
        return this.convert();
    }
}

