/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.converter;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.process.ImageProcessor;
import java.io.File;
import org.nrg.plexiViewer.Writer.AnalyzeWriter;
import org.nrg.plexiViewer.converter.CNL4dfp8BITConverter;
import org.nrg.plexiViewer.converter.plexiLoResConverterI;
import org.nrg.plexiViewer.io.IOHelper;
import org.nrg.plexiViewer.io.PlexiFileOpener;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.utils.LiteFileUtils;
import org.nrg.plexiViewer.utils.ArchivePathManager;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.ImageUtils;
import org.nrg.plexiViewer.utils.Transform.BitConverter;
import org.nrg.plexiViewer.utils.Transform.ImaTo4dfpBuilder;
import org.nrg.plexiViewer.utils.Transform.IntensitySetter;
import org.nrg.plexiViewer.utils.Transform.PlexiImageOrientor;
import org.nrg.plexiViewer.utils.Transform.plexiViewerImageRelayer;
import org.nrg.xft.XFT;

public class DefaultConverter
implements plexiLoResConverterI {
    UserSelection options;
    FileInfo fi;
    String fromFileName;
    String toFileName = null;
    String fromPath;
    String toPath = null;
    String cachePath;
    String baseOrientation;
    double minIntensity;
    double maxIntensity;
    boolean single = false;
    String cachePathLocation;
    String loResArchiveLocation;
    final String IMAGE_FORMAT = "ANALYZE";

    public DefaultConverter(UserSelection options) {
        this.options = options;
        this.cachePathLocation = ArchivePathManager.GetInstance().getCachePathLocation(options.getProject(), options.getSessionLabel());
        this.loResArchiveLocation = ArchivePathManager.GetInstance().getLoResLocation(options.getProject(), options.getSessionLabel());
    }

    public int convert() {
        if (this.options.getHiResLayerNum() >= 0 && this.options.getOrientation() != null) {
            this.single = true;
        } else if (this.options.hasFile() && this.options.getOrientation() != null) {
            this.single = true;
        }
        System.out.println("Create for a single file: " + this.single);
        int rtn = 0;
        try {
            rtn = this.doConvert();
        }
        catch (Exception e) {
            e.printStackTrace();
            rtn = 1;
        }
        return rtn;
    }

    protected ImagePlus getImage(Integer layerNum) throws Exception {
        String sessionId = this.options.getSessionId();
        PlexiImageFile pf = null;
        if (this.options.hasFile()) {
            pf = this.options.getFile();
        } else if (this.options.hasXnatFile()) {
            pf = IOHelper.getPlexiImageFile(this.options.getXnatFile(), this.cachePathLocation, this.options.getFormattedWindowTitle() + "_" + LiteFileUtils.getFileName(this.options.getXnatFile()));
        }
        this.fromPath = pf.getPath();
        this.fromFileName = pf.getName();
        System.out.println("From File Name is " + this.fromFileName);
        this.cachePath = pf.getCachePath();
        ImagePlus image = null;
        if (pf.getFormat().equalsIgnoreCase("IMA")) {
            System.out.println(" Will look at cachepath " + pf.getCachePath());
            ImaTo4dfpBuilder imato4dfp = new ImaTo4dfpBuilder(pf);
            imato4dfp.create();
            image = this.openBaseFile("IFH", pf);
        } else {
            image = this.openBaseFile(pf);
        }
        if (image == null) {
            System.out.println("Couldnt create HiRes image...Exiting\n");
            return null;
        }
        return image;
    }

    protected ImagePlus getImage() throws Exception {
        String sessionId = this.options.getSessionId();
        PlexiImageFile pf = null;
        if (this.options.hasFile()) {
            pf = this.options.getFile();
        } else if (this.options.hasXnatFile()) {
            pf = IOHelper.getPlexiImageFile(this.options.getXnatFile(), this.cachePathLocation, this.options.getFormattedWindowTitle() + "_" + LiteFileUtils.getFileName(this.options.getXnatFile()));
        }
        this.fromPath = pf.getPath();
        this.cachePath = pf.getCachePath();
        ImagePlus image = null;
        System.out.println("DefaultConveter::getImage " + pf.getFormat() + "  " + this.fromFileName);
        if (pf.getFormat().equalsIgnoreCase("IMA")) {
            pf.setFormat("IMA");
            ImaTo4dfpBuilder imato4dfp = new ImaTo4dfpBuilder(pf);
            imato4dfp.create();
            image = this.openBaseFile("IFH", pf);
        } else {
            image = this.openBaseFile(pf);
        }
        this.fromFileName = pf.getName();
        if (image == null) {
            System.out.println("Couldnt create HiRes image...Exiting\n");
            return null;
        }
        return image;
    }

    private String setToFileName() {
        String ext = "HiRes";
        if (this.options.getLoResType() != null) {
            ext = this.options.getLoResType();
        }
        this.toFileName = FileUtils.getLoResFileName(this.fromFileName, ext, this.options.getOrientation());
        return this.toFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNames(ImagePlus image) {
        this.setToFileName();
        if (this.toPath == null) {
            this.toPath = this.loResArchiveLocation;
        }
        System.out.println("DefaultConverter::setNames ToPath " + this.toPath + " " + this.toFileName);
        boolean exists = FileUtils.fileExists(this.toPath, this.toFileName);
        if (!exists || this.options.canOverwrite()) {
            ImagePlus adjust = new ImagePlus();
            try {
                adjust.setCalibration(image.getCalibration());
                adjust.setFileInfo(image.getOriginalFileInfo());
                if (image.getStackSize() > 1) {
                    adjust.setStack("", image.getStack());
                } else {
                    adjust.setProcessor(image.getTitle(), image.getProcessor());
                }
                this.doPerform(adjust);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                image.flush();
                image = null;
                adjust.flush();
                adjust = null;
            }
        } else {
            System.out.println("File already exists" + this.toPath + "/" + this.toFileName);
        }
    }

    private int doConvert() throws Exception {
        String sessionId = this.options.getSessionId();
        int status = 0;
        if (this.single) {
            ImagePlus image = this.getImage();
            if (image == null) {
                System.out.println("DefaultConvereter::doConvert image is null");
                return 1;
            }
            this.setNames(image);
            if (image != null) {
                image.flush();
            }
            image = null;
        } else {
            ImagePlus image = this.getImage();
            if (image == null) {
                return 1;
            }
            String oldOri = this.options.getOrientation();
            this.options.setOrientation("Transverse");
            this.setNames(image);
            image = this.getImage();
            this.options.setOrientation("Coronal");
            this.setNames(image);
            image = this.getImage();
            this.options.setOrientation("Sagittal");
            this.setNames(image);
            this.options.setOrientation(oldOri);
            if (image != null) {
                image.flush();
            }
            Object var3_4 = null;
        }
        System.gc();
        return status;
    }

    private ImagePlus openBaseFile(String format, PlexiImageFile pf) {
        PlexiFileOpener pfo = new PlexiFileOpener(format, pf);
        ImagePlus image = null;
        image = pfo.getImagePlus();
        if (image == null) {
            System.out.println("Image Converter: couldnt find the  Image File");
            return null;
        }
        this.baseOrientation = pfo.getOrientation();
        if (format.equalsIgnoreCase("IFH")) {
            image = new plexiViewerImageRelayer(this.baseOrientation).Format4dfpImageForImageJ(image);
            this.baseOrientation = pfo.getOrientation() + "F";
        }
        System.out.println("Default Converter:: File Opened");
        return image;
    }

    private ImagePlus openBaseFile(PlexiImageFile pf) {
        return this.openBaseFile(pf.getFormat(), pf);
    }

    private void resize(ImagePlus img1) {
        if (img1.getWidth() >= 800 || img1.getHeight() >= 800) {
            FileInfo fi;
            double scale = 0.75;
            int stackWidth = img1.getWidth();
            int stackHeight = img1.getHeight();
            int width = (int)((double)stackWidth * scale);
            int height = (int)((double)stackHeight * scale);
            ImageStack stack = img1.getStack();
            ImageStack stack1 = new ImageStack(width, height);
            if (scale != 1.0) {
                for (int slice = 1; slice <= img1.getStackSize(); ++slice) {
                    ImageProcessor aSlice = stack.getProcessor(slice);
                    aSlice = aSlice.resize(width, height);
                    stack1.addSlice("" + slice, aSlice);
                }
                img1.setStack(img1.getTitle(), stack1);
            }
            if ((fi = img1.getOriginalFileInfo()) != null) {
                fi.width = width;
                fi.height = height;
                img1.setFileInfo(fi);
            }
        }
    }

    private int doPerform(ImagePlus img) {
        try {
            PlexiImageFile pf = null;
            if (this.options.hasFile()) {
                pf = this.options.getFile();
            } else if (this.options.hasXnatFile()) {
                pf = IOHelper.getPlexiImageFile(this.options.getXnatFile(), this.cachePathLocation, this.options.getFormattedWindowTitle() + "_" + LiteFileUtils.getFileName(this.options.getXnatFile()));
            }
            if (!this.options.getDataType().equals("RAW")) {
                IntensitySetter piSetter = new IntensitySetter(img, true);
                piSetter.autoAdjust(img, img.getProcessor());
            }
            PlexiImageOrientor pio = new PlexiImageOrientor(img, pf.getFormat());
            ImagePlus img1 = pio.getImage(this.baseOrientation, this.options.getOrientation() + "F");
            if (!FileUtils.dirExists(this.toPath)) {
                FileUtils.createDirectory(this.toPath);
            }
            String strippedScheme = this.toPath;
            if (this.toPath.startsWith("file:")) {
                strippedScheme = this.toPath.substring(5);
            }
            if (!strippedScheme.endsWith(File.separator)) {
                strippedScheme = strippedScheme + File.separator;
            }
            this.resize(img1);
            BitConverter converter = new BitConverter();
            converter.convertToGrayscale(img1);
            boolean created = false;
            created = img1.getStackSize() == 1 ? new FileSaver(img1).saveAsRaw(strippedScheme + this.toFileName) : new FileSaver(img1).saveAsRawStack(strippedScheme + this.toFileName);
            if (!created) {
                System.out.println("Couldnt create file " + this.toPath + File.separator + this.toFileName);
                pio.clearImage();
                img1.flush();
                img1 = null;
                if (img != null) {
                    img.flush();
                }
                img = null;
                return -1;
            }
            img1.setFileInfo(ImageUtils.getFileInfo(img1.getCalibration(), img1.getWidth(), img1.getHeight(), img1.getStackSize()));
            new AnalyzeWriter().save(img1, strippedScheme, this.toFileName, this.options.getOrientation() + "F");
            System.out.println(this.getClass().getName() + " Created file " + this.toPath + File.separator + this.toFileName);
            pio.clearImage();
            img1.flush();
            img1 = null;
            if (img != null) {
                img.flush();
            }
            img = null;
            return 0;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return -1;
        }
    }

    @Override
    public PlexiImageFile getFileLocationAndName() throws Exception {
        PlexiImageFile pf = new PlexiImageFile();
        pf.setName(this.toFileName);
        pf.setPath(this.toPath);
        pf.setFormat(this.IMAGE_FORMAT);
        try {
            if (pf.getPath().endsWith("/")) {
                pf.setURIAsString(pf.getPath() + pf.getName());
            } else {
                pf.setURIAsString(pf.getPath() + "/" + pf.getName());
            }
        }
        catch (Exception e) {
            System.out.println("DefaultConverter::getFileLocationAndName() couldnt set URI " + pf.getPath() + File.separator + pf.getName());
        }
        pf.setXsiType("plexi:imageResource");
        pf.setCachePath(this.cachePath);
        return pf;
    }

    @Override
    public int convertAndSave(UserSelection u) {
        this.options = u;
        return this.convert();
    }

    public static void main(String[] args) {
        UserSelection u = new UserSelection();
        u.setSessionId("OAS1_0001");
        u.setLoResType("8bit");
        u.setDataType("RAW");
        u.setOrientation("SAGITTAL");
        u.setDisplay("STACK");
        u.setHiResLayerNum(0);
        try {
            XFT.init((String)"C:\\jakarta-tomcat-5.5.4\\webapps\\oasis", (boolean)true, (boolean)true);
            CNL4dfp8BITConverter c = new CNL4dfp8BITConverter(u);
            c.convertAndSave(u);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

