/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.converter;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileSaver;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.io.File;
import org.nrg.plexiViewer.Writer.AnalyzeWriter;
import org.nrg.plexiViewer.io.PlexiFileOpener;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.utils.ImageUtils;

public class RoiCreator {
    String infileURI;
    String outdir;
    String imageType = "ANALYZE";
    String baseOrientation;

    public void createRoi() throws Exception {
        ImagePlus img = this.getImage();
        this.extractRoi(img);
    }

    private void extractRoi(ImagePlus img) {
        for (int i = 1; i <= 255; ++i) {
            ImageStack istack = img.createEmptyStack();
            ImageStack stack = img.getImageStack();
            for (int j = 1; j <= stack.getSize(); ++j) {
                ImageProcessor ip = stack.getProcessor(j);
                ByteProcessor newip = new ByteProcessor(img.getWidth(), img.getHeight());
                if (ip == null) continue;
                for (int y = 0; y < img.getHeight(); ++y) {
                    int[] pixelvalues = new int[img.getWidth()];
                    ip.getRow(0, y, pixelvalues, img.getWidth());
                    for (int k = 0; k < pixelvalues.length; ++k) {
                        if (pixelvalues[k] == i) continue;
                        pixelvalues[k] = 0;
                    }
                    newip.putRow(0, y, pixelvalues, img.getWidth());
                }
                istack.addSlice("j", (ImageProcessor)newip);
            }
            ImagePlus roiImage = new ImagePlus("ROI_" + i, istack);
            this.saveAsAnalyze(i, roiImage);
        }
    }

    private void saveAsAnalyze(int label, ImagePlus img) {
        String toFileName = "roi_" + label + ".img";
        boolean created = new FileSaver(img).saveAsRawStack(this.outdir + toFileName);
        if (created) {
            img.setFileInfo(ImageUtils.getFileInfo(img.getCalibration(), img.getWidth(), img.getHeight(), img.getStackSize()));
            new AnalyzeWriter().save(img, this.outdir, toFileName, this.baseOrientation + "F");
            System.out.println(" Created file " + this.outdir + File.separator + toFileName);
        }
    }

    private ImagePlus getImage() throws Exception {
        PlexiImageFile pf = new PlexiImageFile();
        pf.setURIAsString(this.infileURI);
        pf.setXsiType("xnat:imageResource");
        PlexiFileOpener pfo = new PlexiFileOpener(this.imageType, pf);
        ImagePlus img = pfo.getImagePlus();
        this.baseOrientation = pfo.getOrientation();
        return img;
    }

    public String getInfile() {
        return this.infileURI;
    }

    public void setInfile(String infile) {
        this.infileURI = infile;
    }

    public String getOutdir() {
        return this.outdir;
    }

    public void setOutdir(String outdir) {
        if (!outdir.endsWith(File.separator)) {
            outdir = outdir + File.separator;
        }
        this.outdir = outdir;
    }

    public static void main(String[] args) {
        String infilepath = args[0];
        String outdir = args[1];
        RoiCreator roiCreator = new RoiCreator();
        roiCreator.setInfile(infilepath);
        roiCreator.setOutdir(outdir);
        try {
            roiCreator.createRoi();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

