/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.file;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

public class ImageFile {
    String format;
    boolean remote = false;
    String localPath;
    String localFileName;

    private void importFile(URI uri, String suffix) throws IOException, URISyntaxException {
        LocalFile dir = null;
        System.out.println("URI Path " + uri.getPath());
        if (dir == null) {
            dir = (LocalFile)LocalFile.createTempFile((String)"NRG", (String)suffix);
            dir.delete();
            dir.mkdir();
        }
        this.get(new URI(StringUtils.replace((String)uri.toString(), (String)".img", (String)".*")), dir);
    }

    private void printMetaData(GeneralFile file) {
        try {
            MetaDataRecordList[] rl = file.query(new String[]{"definable metadata for files"});
            if (rl != null) {
                System.out.println("File " + file.getName());
                System.out.println("rl " + rl.length);
                System.out.println("Name \t Value");
                for (int i = 0; i < rl.length; ++i) {
                    MetaDataTable table = (MetaDataTable)rl[i].getValue(SRBMetaDataSet.getField((String)"definable metadata for files"));
                    for (int j = 0; j < table.getRowCount(); ++j) {
                        System.out.println(table.getStringValue(j, 0) + "\t" + table.getStringValue(j, 1));
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private MetaDataTable getMetaData(String metaData) {
        String[][] definableMetaDataValues = new String[1][2];
        definableMetaDataValues[0][0] = "ASSOCIATED_WITH";
        definableMetaDataValues[0][1] = metaData;
        int[] operators = new int[definableMetaDataValues.length];
        operators[0] = 0;
        return new MetaDataTable(operators, definableMetaDataValues);
    }

    private void getMatchingFiles(String dir, String fileName, String metaData) {
        MetaDataRecordList[] rl1 = null;
        MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition((String)"directory name", (int)0, (String)dir), MetaDataSet.newCondition((String)"file name", (int)10, (String)fileName)};
        MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection((String)"file name")};
        MetaDataTable metaDataTable = null;
        try {
            SRBFileSystem srbFileSystem = new SRBFileSystem();
            MetaDataRecordList[] rl = srbFileSystem.query(conditions, selects);
            if (rl != null) {
                for (int i = 0; i < rl.length; ++i) {
                    System.out.println("File is " + rl[i].getStringValue(0));
                    SRBFile file = new SRBFile(srbFileSystem, dir + "/" + rl[i].getStringValue(0));
                    MetaDataField field = SRBMetaDataSet.getField((String)"definable metadata for files");
                    rl1 = file.query(new String[]{"definable metadata for files"});
                    metaDataTable = (MetaDataTable)rl[0].getValue(field);
                    if (rl1 == null) {
                        rl1 = new MetaDataRecordList[1];
                    }
                    if (metaDataTable == null) {
                        metaDataTable = this.getMetaData(metaData);
                    } else {
                        metaDataTable.addRow(new String[]{"ASSOCIATED_WITH"}, 0);
                    }
                    rl1[0] = new SRBMetaDataRecordList(field, metaDataTable);
                    file.modifyMetaData(rl1[0]);
                    this.printMetaData((GeneralFile)file);
                }
            } else {
                System.out.println("Rl is null");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void get(URI uri, LocalFile dir) throws IOException {
        SRBFile file = null;
        LocalFile localFile = null;
        System.out.println("URI " + uri.toString());
        file = new SRBFile(new SRBFileSystem(), uri.getPath());
        if (file != null && file.exists()) {
            System.out.println("File Name " + file.getName());
            System.out.println("File Path " + file.getParent());
            localFile = new LocalFile(dir, file.getName());
            file.copyTo((GeneralFile)localFile);
            System.out.println("File " + file.getPath() + " copied to " + localFile.getAbsolutePath());
        } else {
            System.out.println("File doesnt exist");
        }
    }

    public void openFile(URI uri, String suffix) throws IOException, URISyntaxException {
        System.out.println("URI recd " + uri);
        System.out.println("URI scheme " + uri.getScheme());
        if (suffix == null) {
            suffix = "_" + new Random().nextInt();
        }
        if (uri.getScheme() != null && uri.getScheme().startsWith("srb")) {
            this.importFile(uri, suffix);
            this.remote = true;
        } else {
            File file = new File(uri);
        }
    }

    public static void main(String[] args) {
        try {
            ImageFile i = new ImageFile();
            i.getMatchingFiles("/home/dmarcus.wustl-nrg/oasis/set1/disc1/OAS1_0001_MR1/PROCESSED/MPRAGE/T88_111", "OAS1_0001_MR1_mpr_n4_anon_111_t88_gfc.*", "OAS1_0001_MR1_mpr_n4_anon_111_t88_gfc.img");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

