/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.io;

import ij.ImagePlus;
import java.io.File;
import org.nrg.plexiViewer.converter.ConverterUtils;
import org.nrg.plexiViewer.exceptions.InvalidParameterValueException;
import org.nrg.plexiViewer.io.ImageLoaderI;
import org.nrg.plexiViewer.io.PlexiFileOpener;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.xml.Layout;
import org.nrg.plexiViewer.lite.xml.MontageView;
import org.nrg.plexiViewer.lite.xml.ViewableItem;
import org.nrg.plexiViewer.manager.PlexiSpecDocReader;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.Transform.PlexiImageOrientor;
import org.nrg.plexiViewer.utils.Transform.ReOrientMakeMontage;

public class HiResLoader
implements ImageLoaderI {
    private UserSelection userOptions;
    MontageView mView;
    Layout layout;
    MontageDisplay mDisplay;
    PlexiImageFile openedImageFile;

    public HiResLoader(UserSelection opt) {
        this.userOptions = opt;
    }

    @Override
    public ImagePlus load() throws InvalidParameterValueException {
        ImagePlus image = null;
        ViewableItem vi = PlexiSpecDocReader.GetInstance().getSpecDoc(this.userOptions.getProject()).getViewableItem(this.userOptions.getDataType());
        this.mView = vi.getHiRes().getMontageView();
        this.layout = vi.getHiRes().getLayout();
        String format = vi.getHiRes().getFormat();
        this.mDisplay = new MontageDisplay(this.mView, this.userOptions.getOrientation().toUpperCase(), this.layout);
        PlexiImageFile hpf = this.userOptions.getFile();
        if (hpf == null) {
            hpf = FileUtils.getHiResFilePath(this.userOptions.getSessionId(), this.userOptions.getProject(), this.userOptions.getDataType(), this.userOptions.getHiResLayerNum(), this.userOptions.getScanNo());
        }
        System.out.println("HIResLoader file details are " + hpf.toString());
        PlexiImageFile pf = new PlexiImageFile();
        if (format.equalsIgnoreCase("DICOM")) {
            pf = hpf;
            System.out.println("The MontageView is " + this.mView);
            PlexiFileOpener pfo = new PlexiFileOpener(format, pf);
            image = pfo.getImagePlus();
            PlexiImageOrientor pio = new PlexiImageOrientor(image, "DICOM");
            image = pio.getImage(pfo.getOrientation(), this.userOptions.getOrientation());
            ReOrientMakeMontage rm = new ReOrientMakeMontage(this.userOptions, format, this.getMontageDisplay());
            image = rm.doPerform(image);
        } else {
            pf.setPath(hpf.getCachePath());
            pf.setName(FileUtils.getLoResFileName(hpf.getName(), "HiRes", this.userOptions.getOrientation()));
            pf = FileUtils.fileExists(pf);
            if (pf == null) {
                System.out.println("File doesnt exists ");
                this.userOptions.setFile(hpf);
                pf = ConverterUtils.convert(this.userOptions);
                if (pf == null) {
                    System.out.println("Couldnt launch the conveter");
                    return null;
                }
            }
            System.out.println("Looking out for the Hi Res Oriented file " + pf.getPath() + File.separator + pf.getName());
            if (format.equalsIgnoreCase("IMA")) {
                format = "IFH";
            }
            PlexiFileOpener pfo = new PlexiFileOpener(format, pf);
            image = pfo.getImagePlus();
            ReOrientMakeMontage rm = new ReOrientMakeMontage(this.userOptions, format, this.getMontageDisplay());
            image = rm.doPerform(image);
        }
        this.openedImageFile = pf;
        return image;
    }

    @Override
    public PlexiImageFile getPlexiImageFile() {
        return this.openedImageFile;
    }

    @Override
    public MontageDisplay getMontageDisplay() {
        return this.mDisplay;
    }
}

