/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.io;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import org.nrg.plexiViewer.io.HiResLoader;
import org.nrg.plexiViewer.io.ImageLoaderI;
import org.nrg.plexiViewer.io.LoResLoader;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.xft.XFT;

public class ImageLoader {
    UserSelection opt;
    PlexiImageFile openedImageFile;
    MontageDisplay mDisplay;

    public ImageLoader(UserSelection options) {
        this.opt = options;
    }

    public ImagePlus getImage(String imageType, boolean convertHiResToDefaultLoRes) {
        ImagePlus img = null;
        try {
            ImageLoaderI loader = null;
            if (imageType.equalsIgnoreCase("LoRes")) {
                loader = new LoResLoader(this.opt);
            } else if (imageType.equalsIgnoreCase("HiRes")) {
                loader = new HiResLoader(this.opt);
            }
            img = loader.load();
            System.out.println("ImageLoader is in charge");
            if (img != null) {
                this.mDisplay = loader.getMontageDisplay();
                this.openedImageFile = loader.getPlexiImageFile();
                System.out.println("ImageLoader openedIamgeFile " + this.openedImageFile.toString());
                System.out.println("ImageLoader getIamgeFile " + this.getPlexiImageFile().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    boolean isSigned16Bit(ImagePlus imp) {
        if (imp.getType() != 1) {
            return false;
        }
        return imp.getCalibration().getCValue(0) == -32768.0;
    }

    void add(ImagePlus imp, int value) {
        ImageStack stack = imp.getStack();
        for (int slice = 1; slice <= stack.getSize(); ++slice) {
            ImageProcessor ip = stack.getProcessor(slice);
            short[] pixels = (short[])ip.getPixels();
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = (short)((pixels[i] & 0xFFFF) + value);
            }
        }
    }

    public ImagePlus getImage() {
        ImagePlus img = null;
        try {
            ImageLoaderI loader = null;
            try {
                loader = new LoResLoader(this.opt);
            }
            catch (Exception e) {
                loader = new HiResLoader(this.opt);
            }
            img = loader.load();
            System.out.println("ImageLoader is in charge");
            this.openedImageFile = loader.getPlexiImageFile();
            if (img != null) {
                this.mDisplay = loader.getMontageDisplay();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public PlexiImageFile getPlexiImageFile() {
        return this.openedImageFile;
    }

    public MontageDisplay getMontageDisplay() {
        return this.mDisplay;
    }

    public static void main(String[] args) {
        UserSelection u = new UserSelection();
        u.setSessionId("000112_vc1552");
        u.setDataType("T88");
        u.setOrientation("Coronal");
        u.setDisplay("Montage");
        u.setHiResLayerNum(0);
        try {
            XFT.init((String)"C:\\jakarta-tomcat-5.5.4\\webapps\\cnda_xnat", (boolean)true, (boolean)true);
            ImageLoader loader = new ImageLoader(u);
            ImagePlus image = loader.getImage();
            image.show();
            System.out.println("PLexi Image File " + loader.getPlexiImageFile().toString());
            System.out.println("Done ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

