/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.io;

import ij.io.FileInfo;
import org.nrg.plexiViewer.Reader.PlexiImageHeaderReader;
import org.nrg.plexiViewer.converter.ConverterUtils;
import org.nrg.plexiViewer.io.IOHelper;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.utils.ImageDetails;
import org.nrg.plexiViewer.lite.utils.LiteFileUtils;
import org.nrg.plexiViewer.manager.PlexiStatusPublisherManager;
import org.nrg.plexiViewer.utils.ArchivePathManager;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.URIUtils;

public class ImageLocator {
    public PlexiImageFile getImage(UserSelection options) throws Exception {
        PlexiImageFile hpf = new PlexiImageFile();
        PlexiImageFile pf = new PlexiImageFile();
        String cloneWithoutFiles = options.toString();
        boolean build = false;
        String format = null;
        String cachePathLocation = ArchivePathManager.GetInstance().getCachePathLocation(options.getProject(), options.getSessionLabel());
        String loresLocation = ArchivePathManager.GetInstance().getLoResLocation(options.getProject(), options.getSessionLabel());
        String loresType = ImageDetails.getDefaultLoresType();
        if (options.hasFile()) {
            hpf = options.getFile();
        } else if (options.hasXnatFile()) {
            hpf = IOHelper.getPlexiImageFile(options.getXnatFile(), cachePathLocation, options.getFormattedWindowTitle() + "_" + LiteFileUtils.getFileName(options.getXnatFile()));
        }
        System.out.println("ImageLocator HIRes File Details are " + hpf);
        options.setLoResType(loresType);
        System.out.println("ImageLocator LoRes Type to look out for are " + options.getLoResType());
        pf.setPath(URIUtils.getURI(loresLocation).toString());
        if (hpf.getFormat() != null && hpf.getFormat().equals("IMA")) {
            pf.setName(FileUtils.getLoResFileName(hpf.getName() + "_" + options.getScanNo() + ".4dfp.img", loresType, options.getOrientation()));
        } else {
            pf.setName(FileUtils.getLoResFileName(hpf.getName() + "_" + options.getScanNo(), loresType, options.getOrientation()));
        }
        if (pf.getPath().endsWith("/")) {
            pf.setURIAsString(pf.getPath() + pf.getName());
        } else {
            pf.setURIAsString(pf.getPath() + "/" + pf.getName());
        }
        pf.setCachePath(hpf.getCachePath());
        pf.setXsiType("plexi:imageResource");
        format = ImageDetails.getDefaultLoresFormat();
        System.out.println("ImageLocator LoRes File to be looked out for " + pf.toString() + " Format " + format);
        pf = FileUtils.fileExists(pf);
        if (pf == null) {
            pf = hpf;
            format = pf.getFormat();
            build = true;
        }
        System.out.println("ImageLocator will look for " + pf.toString());
        if (build) {
            PlexiStatusPublisherManager.GetInstance().getPublisher(cloneWithoutFiles).setValue("Building requested Image");
            pf = ConverterUtils.convert(options);
            format = pf.getFormat();
        } else {
            PlexiStatusPublisherManager.GetInstance().getPublisher(cloneWithoutFiles).setValue("Delivering requested Image");
        }
        PlexiImageHeaderReader xIReader = new PlexiImageHeaderReader(format);
        String path = pf.getPath();
        if (path.startsWith("file:")) {
            path = path.replaceAll("file:", "");
        }
        FileInfo fi = xIReader.getFileInfo(path, pf.getName());
        pf = hpf;
        pf.setDimX(fi.width);
        pf.setDimY(fi.height);
        pf.setDimZ(fi.nImages);
        pf.setFileType(fi.fileType);
        pf.setVoxelResX(fi.pixelWidth);
        pf.setVoxelResY(fi.pixelHeight);
        pf.setVoxelResZ(fi.pixelDepth);
        return pf;
    }
}

