/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.io;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.local.LocalFile;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.process.StackProcessor;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.nrg.nrrd.NRRDReader;
import org.nrg.plexiViewer.Reader.PlexiImageHeaderReader;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.Transform.ImaTo4dfpBuilder;
import org.nrg.plexiViewer.utils.Transform.PlexiImageOrientor;
import org.nrg.plexiViewer.utils.Transform.PlexiMontageMaker;
import org.nrg.plexiViewer.utils.Transform.plexiViewerImageRelayer;
import org.nrg.plexiViewer.utils.URIUtils;
import org.nrg.plexiViewer.utils.imageformats.DicomFileOpener;
import org.nrg.xdat.bean.CatCatalogBean;
import org.nrg.xdat.bean.CatEntryBean;
import org.nrg.xdat.bean.base.BaseElement;
import org.nrg.xdat.bean.reader.SRBXDATXMLReader;
import org.nrg.xnat.srb.XNATDirectory;
import org.nrg.xnat.srb.XNATSrbSearch;

public class PlexiFileOpener {
    String orientation;
    String fileType;
    FileInfo fi;
    PlexiImageFile pf;
    String fileSystemPath = null;
    String fromFileName;
    boolean remote = false;
    LocalFile tempdir = null;

    public PlexiFileOpener(String format, PlexiImageFile p) {
        this.fileType = format;
        this.pf = p;
        this.remote = this.isRemote(this.pf);
    }

    public LocalFile getDir() throws IOException {
        LocalFile tempDir;
        String suffix = "_" + new Random().nextInt();
        LocalFile dir = (LocalFile)LocalFile.createTempFile((String)"NRG", (String)suffix, (GeneralFile)(tempDir = new LocalFile(new File(FileUtils.getTempFolder()))));
        if (dir.exists()) {
            dir.delete();
        }
        dir.mkdir();
        return dir;
    }

    public boolean isRemote(PlexiImageFile pf) {
        boolean rtn = false;
        if ("plexi:imageResource".equals(pf.getXsiType()) || "xnat:imageResource".equals(pf.getXsiType())) {
            try {
                rtn = new URIUtils(new URI(pf.getURIAsString())).isRemote();
            }
            catch (URISyntaxException urie) {
                System.out.println("PlexiFileOpener::isRemote " + urie.getMessage() + " " + pf.getURIAsString());
            }
        } else if ("xnat:dicomSeries".equalsIgnoreCase(pf.getXsiType())) {
            if (pf.getFiles() != null && pf.getFiles().size() > 0) {
                rtn = new URIUtils((String)pf.getFiles().get(0)).isRemote();
            }
        } else if ("xnat:imageResourceSeries".equals(pf.getXsiType())) {
            if (pf.getPath() != null) {
                try {
                    rtn = new URIUtils(new URI(pf.getPath())).isRemote();
                }
                catch (Exception e) {
                    System.out.println("PlexiImageFile:: isRemote Recd malformed URI " + pf.getPath());
                }
            }
        } else if ("xnat:resourceCatalog".equals(pf.getXsiType()) && pf.getResourceCatalogPath() != null) {
            try {
                rtn = new URIUtils(new URI(pf.getResourceCatalogPath())).isRemote();
            }
            catch (Exception e) {
                System.out.println("PlexiImageFile:: isRemote Recd malformed URI " + pf.getResourceCatalogPath());
            }
        }
        return rtn;
    }

    public ArrayList copyLocal(ArrayList fileList) throws IOException, URISyntaxException {
        ArrayList<File> rtn = new ArrayList<File>();
        if (this.remote) {
            LocalFile dir = this.getDir();
            this.fileSystemPath = dir.getPath();
            for (int i = 0; i < fileList.size(); ++i) {
                this.copyLocal((URI)fileList.get(i), dir);
                rtn.add(new File(this.fileSystemPath + File.separator + this.fromFileName));
            }
            this.tempdir = dir;
        } else {
            for (int i = 0; i < fileList.size(); ++i) {
                File f = new File((String)fileList.get(i));
                if (!f.exists()) {
                    URI uri = URIUtils.getURI((String)fileList.get(i));
                    f = new File(uri);
                }
                rtn.add(f);
            }
        }
        return rtn;
    }

    public boolean copyLocal(String pfUriAsString, String pfPath, String pfName, String pfPattern, LocalFile dir) {
        boolean success = true;
        Object path = null;
        Object name = null;
        try {
            URI pfUri = new URI(pfUriAsString);
            URIUtils uUtils = new URIUtils(pfUri);
            if (this.remote) {
                XNATDirectory srbDir = XNATSrbSearch.getFilesLike((String)pfPath, (String)pfPattern);
                if (srbDir == null) {
                    return !success;
                }
                srbDir.importFiles(dir);
                if (this.fileSystemPath == null) {
                    this.fileSystemPath = dir.getPath();
                }
                this.fromFileName = pfName;
                this.tempdir = dir;
            }
            if (this.fileSystemPath == null) {
                this.fileSystemPath = path;
            }
            this.fromFileName = name;
            return success;
        }
        catch (Exception e) {
            this.fromFileName = null;
            this.fileSystemPath = null;
            return !success;
        }
    }

    public boolean copyLocal(URI pathUri, LocalFile dir) {
        URIUtils uUtils = new URIUtils(pathUri);
        boolean success = true;
        String path = null;
        String name = null;
        try {
            path = uUtils.getPath();
            name = uUtils.getName();
            if (path == null || name == null) {
                this.fromFileName = null;
                this.fileSystemPath = null;
                return !success;
            }
            if (this.remote) {
                XNATDirectory srbDir;
                if (dir == null) {
                    this.tempdir = dir = this.getDir();
                }
                if ((srbDir = XNATSrbSearch.getFilesAssociatedWith((String)(path = StringUtils.replace((String)path, (String)("/" + name), (String)"")), (String)name)) == null) {
                    return !success;
                }
                srbDir.importFiles(dir);
                if (this.fileSystemPath == null) {
                    this.fileSystemPath = dir.getPath();
                }
            } else {
                path = StringUtils.replace((String)path, (String)(File.separator + name), (String)"");
            }
            if (this.fileSystemPath == null) {
                this.fileSystemPath = path;
            }
            this.fromFileName = name;
            return success;
        }
        catch (Exception e) {
            this.fromFileName = null;
            this.fileSystemPath = null;
            return !success;
        }
    }

    private ArrayList readResourceCatalog(String fullPath) throws Exception {
        String path = fullPath;
        try {
            File f = new File(fullPath);
            if (f.exists()) {
                path = f.getAbsolutePath();
            } else {
                f = new File(new URI(fullPath));
                path = f.getAbsolutePath();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SRBXDATXMLReader reader = new SRBXDATXMLReader();
        BaseElement base = reader.parse(path);
        ArrayList<String> rtn = new ArrayList<String>();
        URI parentURI = new URI(fullPath);
        if (base instanceof CatCatalogBean) {
            List entries = ((CatCatalogBean)base).getEntries_entry();
            for (int j = 0; j < entries.size(); ++j) {
                CatEntryBean entry = (CatEntryBean)entries.get(j);
                rtn.add(parentURI.resolve(entry.getUri()).toString());
            }
        }
        return rtn;
    }

    private ArrayList getResourceCatalogEntries(String fullPath) throws Exception {
        String path = fullPath;
        try {
            File f = new File(fullPath);
            if (f.exists()) {
                path = f.getAbsolutePath();
            } else {
                f = new File(new URI(fullPath));
                path = f.getAbsolutePath();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SRBXDATXMLReader reader = new SRBXDATXMLReader();
        BaseElement base = reader.parse(path);
        ArrayList<CatEntryBean> rtn = new ArrayList<CatEntryBean>();
        URI parentURI = new URI(fullPath);
        if (base instanceof CatCatalogBean) {
            List entries = ((CatCatalogBean)base).getEntries_entry();
            for (int j = 0; j < entries.size(); ++j) {
                CatEntryBean entry = (CatEntryBean)entries.get(j);
                entry.setUri(parentURI.resolve(entry.getUri()).toString());
                rtn.add(entry);
            }
        }
        return rtn;
    }

    public ImagePlus getImagePlus() {
        try {
            ImagePlus image;
            Opener fo;
            if (this.fileType.equalsIgnoreCase("DICOM")) {
                if (this.pf.getFiles() != null && this.pf.getFiles().size() > 0) {
                    ArrayList localFiles = this.copyLocal(this.pf.getFiles());
                    DicomFileOpener dcmSeq = new DicomFileOpener(localFiles);
                    ImagePlus img = dcmSeq.getImagePlus();
                    this.orientation = dcmSeq.getOrientation();
                    this.fi = img.getOriginalFileInfo();
                    if (this.remote) {
                        FileUtils.deleteFile(this.tempdir);
                    }
                    return img;
                }
                if (this.pf.getPath() != null) {
                    this.copyLocal(new URI(this.pf.getPath()), null);
                    if (this.fileSystemPath == null) {
                        return null;
                    }
                    DicomFileOpener dcmSeq = new DicomFileOpener(this.fileSystemPath);
                    ImagePlus img = dcmSeq.getImagePlus();
                    this.orientation = dcmSeq.getOrientation();
                    this.fi = img.getOriginalFileInfo();
                    FileUtils.deleteFile(this.tempdir);
                    return img;
                }
                if (this.pf.getXsiType().equals("xnat:resourceCatalog")) {
                    ArrayList localFilePaths = this.readResourceCatalog(this.pf.getResourceCatalogPath());
                    ArrayList localFiles = this.copyLocal(localFilePaths);
                    DicomFileOpener dcmSeq = new DicomFileOpener(localFiles);
                    ImagePlus img = dcmSeq.getImagePlus();
                    this.orientation = dcmSeq.getOrientation();
                    this.fi = img.getOriginalFileInfo();
                    if (this.remote) {
                        FileUtils.deleteFile(this.tempdir);
                    }
                    return img;
                }
                return null;
            }
            if (this.fileType.equalsIgnoreCase("NRRD")) {
                NRRDReader nrrdReader = null;
                if (this.pf.getXsiType().equals("xnat:resourceCatalog")) {
                    ArrayList localFilePaths = this.readResourceCatalog(this.pf.getResourceCatalogPath());
                    ArrayList localFiles = this.copyLocal(localFilePaths);
                    File file = (File)localFiles.get(0);
                    nrrdReader = new NRRDReader(file.getParent(), file.getName());
                    this.orientation = nrrdReader.getOrientation();
                    ImagePlus img = nrrdReader.getImagePlus();
                    nrrdReader.clearTempFolder();
                    return img;
                }
            }
            URI fileUri = null;
            if (this.pf.getXsiType().equals("xnat:resourceCatalog")) {
                ArrayList localFilePaths = this.readResourceCatalog(this.pf.getResourceCatalogPath());
                ArrayList localFiles = this.copyLocal(localFilePaths);
                File file = (File)localFiles.get(0);
                this.fileSystemPath = file.getParent();
                this.fromFileName = file.getName();
            } else if (this.pf.getXsiType().equals("xnat:imageResource")) {
                try {
                    fileUri = new URI(this.pf.getURIAsString());
                }
                catch (URISyntaxException urie) {
                    System.out.println("PlexiFileOpenere::getImagePlus invalid uri " + this.pf.getURIAsString());
                }
                if (fileUri != null) {
                    this.copyLocal(fileUri, null);
                }
            } else if (this.pf.getXsiType().equals("plexi:imageResource")) {
                this.fileSystemPath = this.pf.getPath();
                if (this.fileSystemPath.startsWith("file:")) {
                    this.fileSystemPath = this.fileSystemPath.substring(5);
                }
                this.fromFileName = this.pf.getName();
            } else if (this.pf.getXsiType().equals("xnat:imageResourceSeries")) {
                if (this.pf.getPattern() != null) {
                    this.copyLocal(this.pf.getURIAsString(), this.pf.getPath(), this.pf.getName(), this.pf.getPattern(), this.getDir());
                }
            } else {
                this.fileSystemPath = this.pf.getPath();
                this.fromFileName = this.pf.getName();
                System.out.println("PF is not an xnat type image");
            }
            PlexiImageHeaderReader xIReader = new PlexiImageHeaderReader(this.fileType);
            this.fi = xIReader.getFileInfo(this.fileSystemPath, this.fromFileName);
            if (this.fi == null) {
                System.out.println("The Image File Reader returned a null FileInfo object\n");
                return null;
            }
            if (!xIReader.isGIF_JPG_Others()) {
                fo = new FileOpener(this.fi);
                image = fo.open(false);
                if (image == null) {
                    System.out.println("PlexiFileOpener::Couldnt open file: " + this.fileSystemPath + this.fromFileName);
                    return null;
                }
                this.orientation = xIReader.getOrientation();
                Calibration c = new Calibration();
                c.pixelWidth = this.fi.pixelWidth;
                c.pixelHeight = this.fi.pixelHeight;
                c.pixelDepth = this.fi.pixelDepth;
                c.setUnit(this.fi.unit);
                image.setCalibration(c);
                image.setFileInfo(this.fi);
                if (this.remote) {
                    FileUtils.deleteFile(this.tempdir);
                }
                xIReader.clearTempFolder();
                return image;
            }
            fo = new Opener();
            image = fo.openImage(this.fileSystemPath, this.fromFileName);
            if (this.remote) {
                FileUtils.deleteFile(new File(this.fileSystemPath));
            }
            xIReader.clearTempFolder();
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String string) {
        this.orientation = string;
    }

    public FileInfo getFileInfo() {
        return this.fi;
    }

    public static ImagePlus openBaseFile(String format, PlexiImageFile pf, boolean radiologic) {
        PlexiFileOpener pfo = new PlexiFileOpener(format, pf);
        ImagePlus image = null;
        image = pfo.getImagePlus();
        if (image == null) {
            System.out.println("Image Converter....couldnt find the  Image File");
            return null;
        }
        String baseOrientation = pfo.getOrientation();
        if (format != null && format.equalsIgnoreCase("IFH")) {
            image = new plexiViewerImageRelayer(baseOrientation).Format4dfpImageForImageJ(image);
            baseOrientation = pfo.getOrientation() + "F";
            pf.setOrientation(baseOrientation);
        } else if (format != null && format.startsWith("ANALYZE")) {
            if (!radiologic && image != null && !radiologic) {
                StackProcessor sp = new StackProcessor(image.getStack(), image.getProcessor());
                sp.flipHorizontal();
                if (pfo.getOrientation().equalsIgnoreCase("sagittal")) {
                    image = new plexiViewerImageRelayer(baseOrientation).reverseStacks(image);
                }
            }
            PlexiImageOrientor pio = new PlexiImageOrientor(image, format);
            image = pio.getImage(baseOrientation, baseOrientation + "F");
            pf.setOrientation(baseOrientation + "F");
        } else {
            pf.setOrientation(baseOrientation);
        }
        return image;
    }

    public static ImagePlus openBaseFile(PlexiImageFile pf, boolean radiologic) {
        ImagePlus image = null;
        ImaTo4dfpBuilder imato4dfp = new ImaTo4dfpBuilder(pf);
        if (imato4dfp.create()) {
            image = PlexiFileOpener.openBaseFile(pf.getFormat(), pf, radiologic);
        }
        return image;
    }

    public static void main(String[] args) {
        try {
            PlexiImageFile pf = new PlexiImageFile();
            pf.setURIAsString("file:/C:/Users/NRG/Downloads/MRH0001001_5_10_2011_14_19_39/MRH0001001/SCANS/1/MPRAGE/struc.nii");
            pf.setXsiType("xnat:imageResource");
            PlexiFileOpener pfo = new PlexiFileOpener("NIFTI", pf);
            ImagePlus img = pfo.getImagePlus();
            System.out.println("Image is " + img.getProcessor().getClass().getName());
            PlexiMontageMaker mm = new PlexiMontageMaker();
            ImagePlus montage = mm.makeMontage(img, 2, 1, 1.0, 54, 56, 1, true, false);
            montage.getProcessor().drawString("Mohana", 50, 50);
            montage.show();
            System.out.println("Found the orientation to be " + pfo.getOrientation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

