/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.io;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.StackProcessor;

public class plexiViewerImageRelayer {
    String orientation;
    String fileName;
    String dir;

    public plexiViewerImageRelayer(String orientation) {
        this.orientation = orientation;
    }

    private ImageStack reverseStack(ImageStack stack, ImagePlus imp) {
        int n;
        ImageStack stack2 = imp.createEmptyStack();
        while ((n = stack.getSize()) > 0) {
            stack2.addSlice(stack.getSliceLabel(n), stack.getProcessor(n));
            stack.deleteLastSlice();
        }
        return stack2;
    }

    public ImagePlus reverseStacks(ImagePlus image) {
        ImageStack stackNew = this.reverseStack(image.getStack(), image);
        ImagePlus tIP = new ImagePlus(image.getTitle(), stackNew);
        tIP.setFileInfo(image.getFileInfo());
        return tIP;
    }

    public ImagePlus FormatDicomImageForImageJ(ImagePlus image) {
        return this.Format4dfpImageForImageJ(image);
    }

    public ImagePlus Format4dfpImageForImageJ(ImagePlus image) {
        ImagePlus rtn = null;
        if (this.getOrientation().equalsIgnoreCase("TRANSVERSE")) {
            StackProcessor sp = new StackProcessor(image.getStack(), image.getProcessor());
            sp.flipVertical();
            rtn = image;
        } else if (this.getOrientation().equalsIgnoreCase("CORONAL")) {
            StackProcessor sp = new StackProcessor(image.getStack(), image.getProcessor());
            sp.flipHorizontal();
            rtn = this.reverseStacks(image);
        } else if (this.getOrientation().equalsIgnoreCase("SAGITTAL")) {
            StackProcessor sp = new StackProcessor(image.getStack(), image.getProcessor());
            sp.flipHorizontal();
            sp.flipVertical();
            rtn = this.reverseStacks(image);
        }
        return rtn;
    }

    public ImagePlus FormatAnalyzeImageForViewer(ImagePlus image) {
        ImagePlus rtn = image;
        StackProcessor sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
        if (this.getOrientation().equalsIgnoreCase("TRANSVERSEF") || this.getOrientation().equalsIgnoreCase("CORONALF") || this.getOrientation().equalsIgnoreCase("SAGITTALF")) {
            System.out.println("Found Flipped..." + this.getOrientation() + "..Flipping image back");
            sp.flipVertical();
            this.orientation = this.orientation.substring(0, this.orientation.length() - 1);
        } else if (this.getOrientation().equalsIgnoreCase("TRANSVERSE") || this.getOrientation().equalsIgnoreCase("CORONAL") || this.getOrientation().equalsIgnoreCase("SAGITTAL")) {
            sp.flipVertical();
            sp.flipHorizontal();
        }
        if (this.getOrientation().equalsIgnoreCase("CORONAL") || this.getOrientation().equalsIgnoreCase("SAGITTAL")) {
            // empty if block
        }
        return rtn;
    }

    public String getOrientation() {
        return this.orientation;
    }
}

