/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.display;

import org.nrg.plexiViewer.lite.display.Point3d;

public class PlexiNativeCoordinates {
    public static Point3d getNativeCoordinates(Point3d winPos, String fromView, String toView, boolean radiologic, Point3d imgDim, boolean fromRadiologic, int scaleFactor) {
        return PlexiNativeCoordinates.getNativeCoordinates((int)winPos.getX(), (int)winPos.getY(), (int)winPos.getZ(), fromView, toView, radiologic, imgDim, fromRadiologic, scaleFactor);
    }

    public static Point3d getTalCoordinates(Point3d talPos, String fromView, String toView, int radiologic, Point3d bboxDim, Point3d imgDim, Point3d origin, int voxelSize, int scaleFactor, boolean fromRadiologic) {
        Point3d rtn = new Point3d();
        int x = 0;
        int y = 0;
        int z = 0;
        if (fromView.equalsIgnoreCase("SAGITTAL")) {
            if (toView.equalsIgnoreCase("CORONAL")) {
                x = (int)((float)radiologic * talPos.z / (float)voxelSize + origin.x);
                y = (int)(bboxDim.z - origin.z - talPos.y / (float)voxelSize);
                z = (int)imgDim.z - (int)origin.getY() + (int)(talPos.x / (float)voxelSize);
            } else if (toView.equalsIgnoreCase("TRANSVERSE")) {
                x = (int)((float)radiologic * talPos.z / (float)voxelSize + origin.x);
                y = (int)(origin.y - talPos.x / (float)voxelSize);
                z = (int)(imgDim.z - (float)((int)(bboxDim.z - origin.z - talPos.y / (float)voxelSize)));
            } else if (toView.equalsIgnoreCase("SAGITTAL")) {
                x = (int)(origin.y - talPos.x / (float)voxelSize);
                y = (int)(bboxDim.z - origin.z - talPos.y / (float)voxelSize);
                z = (int)origin.getX() + (int)(talPos.z / (float)voxelSize);
            }
        } else if (fromView.equalsIgnoreCase("TRANSVERSE")) {
            if (toView.equalsIgnoreCase("TRANSVERSE")) {
                x = (int)((float)radiologic * (talPos.x / (float)voxelSize) + origin.x);
                y = (int)(origin.y - talPos.y / (float)voxelSize);
                z = (int)(talPos.z / (float)voxelSize) + (int)origin.getZ();
            } else if (toView.equalsIgnoreCase("CORONAL")) {
                x = (int)((float)radiologic * talPos.x / (float)voxelSize + origin.x);
                y = (int)(bboxDim.z - origin.z - talPos.z / (float)voxelSize);
                z = (int)imgDim.z - (int)origin.getY() + (int)(talPos.y / (float)voxelSize);
            } else if (toView.equalsIgnoreCase("SAGITTAL")) {
                x = (int)(origin.y - talPos.y / (float)voxelSize);
                y = (int)(bboxDim.z - origin.z - talPos.z / (float)voxelSize);
                z = (int)origin.getX() + (int)(talPos.x / (float)voxelSize);
            }
        } else if (fromView.equalsIgnoreCase("CORONAL")) {
            if (toView.equalsIgnoreCase("CORONAL")) {
                x = (int)((float)radiologic * talPos.x / (float)voxelSize + origin.x);
                y = (int)(bboxDim.z - origin.z - talPos.y / (float)voxelSize);
                z = (int)origin.getY() - (int)(talPos.z / (float)voxelSize);
            } else if (toView.equalsIgnoreCase("SAGITTAL")) {
                x = (int)imgDim.x - (int)(origin.y - talPos.z / (float)voxelSize);
                y = (int)(bboxDim.z - origin.z - talPos.y / (float)voxelSize);
                z = (int)origin.getX() + (int)(talPos.x / (float)voxelSize);
            } else if (toView.equalsIgnoreCase("TRANSVERSE")) {
                x = (int)((float)radiologic * (talPos.x / (float)voxelSize) + origin.x);
                y = (int)imgDim.y - (int)(origin.y - talPos.z / (float)voxelSize);
                z = (int)(talPos.y / (float)voxelSize) + (int)origin.getZ();
            }
        }
        rtn.set(x * scaleFactor, y * scaleFactor, z);
        return rtn;
    }

    public static Point3d getNativeCoordinates(int x, int y, int z, String fromView, String toView, boolean radiologic, Point3d imgDim, boolean fromRadiologic, int scaleFactor) {
        Point3d old;
        Point3d rtn = new Point3d(x, y, z);
        if (fromView.equalsIgnoreCase("SAGITTAL")) {
            if (toView.equalsIgnoreCase("CORONAL")) {
                rtn = new Point3d(z, y, imgDim.z - (float)x);
                if (radiologic) {
                    old = rtn;
                    rtn.setX(imgDim.getX() - old.getX());
                }
            } else if (toView.equalsIgnoreCase("TRANSVERSE")) {
                rtn = new Point3d(z, x, imgDim.z - (float)y);
                if (radiologic) {
                    old = rtn;
                    rtn.setX(imgDim.getX() - old.getX());
                }
            }
        } else if (fromView.equalsIgnoreCase("TRANSVERSE")) {
            if (toView.equalsIgnoreCase("SAGITTAL")) {
                rtn = new Point3d(y, imgDim.y - (float)z, x);
                if (fromRadiologic) {
                    old = rtn;
                    rtn.setZ(imgDim.getZ() - rtn.getZ());
                }
            } else if (toView.equalsIgnoreCase("CORONAL")) {
                rtn = new Point3d(x, imgDim.y - (float)z, imgDim.z - (float)y);
                if (radiologic && !fromRadiologic || !radiologic && fromRadiologic) {
                    old = rtn;
                    rtn.setX(imgDim.getX() - old.getX());
                }
            } else if (radiologic && !fromRadiologic || !radiologic && fromRadiologic) {
                old = rtn;
                rtn.setX(imgDim.getX() - old.getX());
            }
        } else if (fromView.equalsIgnoreCase("CORONAL")) {
            if (toView.equalsIgnoreCase("SAGITTAL")) {
                rtn = new Point3d(imgDim.x - (float)z, y, x);
                if (fromRadiologic) {
                    old = rtn;
                    rtn.setZ(imgDim.getZ() - rtn.getZ());
                }
            } else if (toView.equalsIgnoreCase("TRANSVERSE")) {
                rtn = new Point3d(x, imgDim.y - (float)z, imgDim.z - (float)y);
                if (radiologic && !fromRadiologic || !radiologic && fromRadiologic) {
                    old = rtn;
                    rtn.setX(imgDim.getX() - old.getX());
                }
            } else if (radiologic && !fromRadiologic || !radiologic && fromRadiologic) {
                old = rtn;
                rtn.setX(imgDim.getX() - old.getX());
            }
        }
        old = rtn;
        rtn.set(old.getX() * (float)scaleFactor, old.getY() * (float)scaleFactor, old.getZ());
        return rtn;
    }
}

