/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.gui;

import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.gui.PlexiTextWindow;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;
import org.nrg.plexiViewer.lite.utils.StringUtils;

public class PlexiFileInfo {
    private ImagePlus imp;
    private PlexiTextWindow twin;
    private UserSelection uselection;
    private String host;

    public PlexiFileInfo() {
        this.twin = null;
        this.host = null;
        this.uselection = null;
    }

    public PlexiFileInfo(ImagePlus img) {
        this.imp = img;
        this.twin = null;
        this.host = null;
        this.uselection = null;
    }

    public PlexiFileInfo(ImagePlus img, String host, UserSelection u) {
        this.imp = img;
        this.twin = null;
        this.host = host;
        this.uselection = u;
    }

    public void show() {
        this.showInfo();
    }

    public void showInfo() {
        String info = this.getImageInfo();
        if (info.indexOf("----") > 0) {
            this.showInfo(info, 400, 500);
        } else {
            this.showInfo(info, 300, 300);
        }
    }

    public String getImageInfo() {
        ImageStack stack;
        String label;
        String infoProperty = null;
        if (this.imp.getStackSize() > 1 && (label = (stack = this.imp.getStack()).getSliceLabel(this.imp.getCurrentSlice())) != null && label.indexOf(10) > 0) {
            infoProperty = label;
        }
        if (infoProperty == null) {
            infoProperty = (String)this.imp.getProperty("Info");
        }
        String info = this.getInfo();
        if (infoProperty != null) {
            return infoProperty + "\n------------------------\n" + info;
        }
        return info;
    }

    String getInfo() {
        return this.getInfo(this.imp, this.imp.getProcessor());
    }

    String getInfo(ImagePlus imp, ImageProcessor ip) {
        String rec;
        String s = new String("\n");
        s = s + "Title: " + imp.getTitle() + "\n";
        s = s + "(Note::Image dimensions may not be exact)\n";
        Calibration cal = imp.getCalibration();
        int nSlices = imp.getStackSize();
        String unit = cal.getUnit();
        String units = cal.getUnits();
        s = s + "Width:  " + StringUtils.d2s(imp.getWidth(), 2) + " " + units + " (" + imp.getWidth() + ")\n";
        s = s + "Height:  " + StringUtils.d2s((double)imp.getHeight() * cal.pixelHeight, 2) + " " + units + " (" + imp.getHeight() + ")\n";
        if (nSlices > 1) {
            s = s + "Depth:  " + StringUtils.d2s((double)nSlices * cal.pixelDepth, 2) + " " + units + " (" + nSlices + ")\n";
        }
        if (nSlices > 1) {
            s = s + "Voxel size: " + cal.pixelWidth + "x" + StringUtils.d2s(cal.pixelHeight, 2) + "x" + StringUtils.d2s(cal.pixelDepth, 2) + "\n";
        }
        if (this.host != null && this.uselection != null && !(rec = this.getRecFileDetails()).equals("Rec File Details not available\n")) {
            s = s + "\n--------------REC FILE DETAILS--------------\n";
            s = s + rec;
            s = s + "\n--------------END REC FILE DETAILS--------------\n";
        }
        return s;
    }

    private String getRecFileDetails() {
        String suffix = HTTPDetails.getSuffix("GetRecFileContents");
        try {
            String rtn = "\n";
            URL dataURL = HTTPDetails.getURL(this.host, suffix);
            URLConnection servletConnection = dataURL.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outStreamToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outStreamToServlet.writeObject(this.uselection);
            outStreamToServlet.flush();
            outStreamToServlet.close();
            InputStream is = servletConnection.getInputStream();
            ObjectInputStream in = new ObjectInputStream(is);
            rtn = (String)in.readObject();
            in.close();
            is.close();
            if (rtn == null || rtn.equals("")) {
                rtn = "Rec File Details not available\n";
            }
            return rtn;
        }
        catch (Exception e) {
            return "Rec File Details not available\n";
        }
    }

    public void showInfo(String info, int width, int height) {
        String winTitle = "Info for " + this.imp.getTitle();
        this.twin = new PlexiTextWindow(winTitle, info, width, height);
    }
}

