/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.gui;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Properties;

public class PlexiPrinter {
    private ImagePlus imp;
    private static Properties printPrefs = new Properties();
    private double scaling = 100.0;
    private boolean drawBorder;
    private boolean center = true;

    public PlexiPrinter() {
    }

    public PlexiPrinter(ImagePlus image) {
        this.imp = image;
    }

    public void print(Image img, String title) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob job = toolkit.getPrintJob(new Frame(), title, printPrefs);
        if (job == null) {
            return;
        }
        Graphics g = job.getGraphics();
        if (g == null) {
            return;
        }
        Dimension pageSize = job.getPageDimension();
        double scale = this.scaling / 100.0;
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        int margin = 20;
        int labelHeight = 0;
        int printWidth = (int)((double)width * scale);
        int printHeight = (int)((double)height * scale);
        int maxWidth = pageSize.width - margin * 2;
        int maxHeight = pageSize.height - (margin + labelHeight) * 2;
        g.setColor(Color.black);
        labelHeight = 15;
        g.setFont(new Font("SanSerif", 0, 12));
        g.drawString(title, margin + 5, margin + labelHeight - 3);
        if (this.center && width < maxWidth && height < maxHeight) {
            g.translate((pageSize.width - width) / 2, labelHeight + (pageSize.height - height) / 2);
        } else {
            g.translate(margin, margin + labelHeight);
        }
        if (this.drawBorder) {
            g.drawRect(-1, -1, printWidth + 1, printHeight + 1);
        }
        g.drawImage(img, 0, 0, printWidth, printHeight, null);
        g.dispose();
        job.end();
    }

    public void print(ImagePlus imp) {
        ImageWindow win = imp.getWindow();
        if (win == null) {
            return;
        }
        ImageCanvas ic = win.getCanvas();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob job = toolkit.getPrintJob((Frame)win, imp.getTitle(), printPrefs);
        if (job == null) {
            return;
        }
        Graphics g = job.getGraphics();
        if (g == null) {
            return;
        }
        Dimension pageSize = job.getPageDimension();
        double scale = this.scaling / 100.0;
        int width = imp.getWidth();
        int height = imp.getHeight();
        Roi roi = imp.getRoi();
        boolean crop = false;
        int margin = 20;
        int labelHeight = 0;
        int printWidth = (int)((double)width * scale);
        int printHeight = (int)((double)height * scale);
        int maxWidth = pageSize.width - margin * 2;
        int maxHeight = pageSize.height - (margin + labelHeight) * 2;
        g.setColor(Color.black);
        labelHeight = 15;
        g.setFont(new Font("SanSerif", 0, 12));
        g.drawString(imp.getTitle(), margin + 5, margin + labelHeight - 3);
        ImageProcessor ip = imp.getProcessor();
        if (width > maxWidth || height > maxHeight) {
            double hscale = (double)maxWidth / (double)width;
            double vscale = (double)maxHeight / (double)height;
            scale = hscale <= vscale ? hscale : vscale;
            printWidth = (int)((double)width * scale);
            printHeight = (int)((double)height * scale);
            if (System.getProperty("os.name").startsWith("Windows") && System.getProperty("java.version").startsWith("1.3.1")) {
                ip.setInterpolate(true);
                ip = ip.resize(printWidth, printHeight);
            }
        }
        Image img = ip.createImage();
        if (this.center && width < maxWidth && height < maxHeight) {
            g.translate((pageSize.width - width) / 2, labelHeight + (pageSize.height - height) / 2);
        } else {
            g.translate(margin, margin + labelHeight);
        }
        if (this.drawBorder) {
            g.drawRect(-1, -1, printWidth + 1, printHeight + 1);
        }
        g.drawImage(img, 0, 0, printWidth, printHeight, null);
        g.dispose();
        job.end();
    }
}

