/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.io;

import java.io.Serializable;
import java.util.ArrayList;
import org.nrg.plexiViewer.utils.URIUtils;

public class PlexiImageFile
implements Serializable,
Cloneable {
    String path = null;
    String uri = null;
    String xsiType = null;
    String name = null;
    String pattern = null;
    String cachePathURIAsString;
    String resourceCatalogPath = null;
    ArrayList fileList;
    int dimX = -1;
    int dimY = -1;
    int dimZ = -1;
    int volumes = 1;
    double voxelResX = -1.0;
    double voxelResY = -1.0;
    double voxelResZ = -1.0;
    private int fileType = 0;
    String format;
    String orientation;

    public String getResourceCatalogPath() {
        return this.resourceCatalogPath;
    }

    public void setResourceCatalogPath(String resourceCatalogPath) {
        this.resourceCatalogPath = resourceCatalogPath;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getXsiType() {
        return this.xsiType;
    }

    public void setXsiType(String xsiType) {
        this.xsiType = xsiType;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public PlexiImageFile() {
        this.initFileList();
    }

    public void initFileList() {
        this.fileList = new ArrayList();
    }

    public void addToFiles(String fileURI) {
        this.fileList.add(fileURI);
    }

    public ArrayList getFiles() {
        return this.fileList;
    }

    public String getURIAsString() {
        return this.uri;
    }

    private void setPathAndName() throws Exception {
        URIUtils uUtils = new URIUtils(this.uri);
        String t = uUtils.getPath();
        if (t != null) {
            this.path = t;
        }
        if ((t = uUtils.getName()) != null) {
            this.name = t;
        }
    }

    public void flush() {
        if (this.fileList != null) {
            this.fileList.clear();
        }
    }

    public void setURIAsString(String u) throws Exception {
        if (u != null) {
            this.uri = u.replace("\\", "/");
        }
        if (this.uri != null) {
            this.setPathAndName();
        }
    }

    public String getCachePath() {
        if (this.cachePathURIAsString == null) {
            return "";
        }
        return this.cachePathURIAsString.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setCachePath(String cache) {
        this.cachePathURIAsString = cache;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setDimensions(int dimX, int dimY, int dimZ) {
        this.dimX = dimX;
        this.dimY = dimY;
        this.dimZ = dimZ;
    }

    public void setVoxels(double x, double y, double z) {
        this.voxelResX = x;
        this.voxelResY = y;
        this.voxelResZ = z;
    }

    public int getDimX() {
        return this.dimX;
    }

    public int getDimY() {
        return this.dimY;
    }

    public int getDimZ() {
        return this.dimZ;
    }

    public int getVolumes() {
        return this.volumes;
    }

    public double getVoxelResX() {
        return this.voxelResX;
    }

    public double getVoxelResY() {
        return this.voxelResY;
    }

    public double getVoxelResZ() {
        return this.voxelResZ;
    }

    public void setDimX(int i) {
        this.dimX = i;
    }

    public void setDimY(int i) {
        this.dimY = i;
    }

    public void setDimZ(int i) {
        this.dimZ = i;
    }

    public void setVolumes(int i) {
        this.volumes = i;
    }

    public void setVoxelResX(double f) {
        this.voxelResX = f;
    }

    public void setVoxelResY(double f) {
        this.voxelResY = f;
    }

    public void setVoxelResZ(double f) {
        this.voxelResZ = f;
    }

    public boolean hasDimensions() {
        boolean rtn = false;
        if (this.dimX != -1 && this.dimY != -1 && this.dimZ != -1 && this.volumes != -1) {
            rtn = true;
        }
        return rtn;
    }

    public void resetDimensions() {
        this.dimX = -1;
        this.dimY = -1;
        this.dimZ = -1;
        this.volumes = -1;
    }

    public void resetVoxelRes() {
        this.voxelResX = -1.0;
        this.voxelResY = -1.0;
        this.voxelResZ = -1.0;
    }

    public Object clone() {
        try {
            PlexiImageFile deepClone = (PlexiImageFile)super.clone();
            deepClone.initFileList();
            try {
                for (int i = 0; i < this.fileList.size(); ++i) {
                    deepClone.addToFiles((String)this.fileList.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return deepClone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int type) {
        this.fileType = type;
    }

    public String toString() {
        String rtn = "";
        rtn = rtn + " URI: " + this.uri;
        rtn = rtn + " Name: " + this.name;
        rtn = rtn + " Path: " + this.path;
        rtn = rtn + " ResourceCatalog " + this.resourceCatalogPath;
        rtn = rtn + " Cache Path:" + this.getCachePath();
        rtn = rtn + " Dimensions: " + this.getDimX() + "x" + this.getDimY() + "x" + this.getDimZ() + "x" + this.getVolumes();
        rtn = rtn + " VoxelRes: " + this.getVoxelResX() + "x" + this.getVoxelResY() + "x" + this.getVoxelResZ();
        rtn = rtn + " FileType: " + this.getFileType();
        rtn = rtn + " XsiType " + this.xsiType;
        rtn = rtn + " Format " + this.format;
        if (this.fileList != null) {
            rtn = rtn + " No of files " + this.fileList.size();
        }
        return rtn;
    }

    public static void main(String[] args) {
        PlexiImageFile p = new PlexiImageFile();
        p.clone();
        System.out.println("Cloned");
    }
}

