/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.manager;

import ij.ImagePlus;
import java.applet.Applet;
import java.applet.AppletContext;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.gui.PlexiMessagePanel;
import org.nrg.plexiViewer.lite.manager.PlexiImageViewerI;
import org.nrg.plexiViewer.lite.manager.PlexiManagerI;
import org.nrg.plexiViewer.lite.utils.CreateUtils;
import org.nrg.plexiViewer.lite.viewer.MiriadLobarSeg.SegImage;

public class PlexiManager
implements PlexiManagerI {
    private static Vector mrimages;
    private static AppletContext appletContext;
    public static boolean controlKeys;
    public static final String APPLET_NAME = "PLEXIVIEWER";
    private static Hashtable viewerSettings;

    public PlexiManager(AppletContext a) {
        appletContext = a;
        mrimages = new Vector();
        viewerSettings = new Hashtable();
        PlexiManager.setSetting("SegImage.regionID", new Integer(-1));
    }

    public static void show(URL url) {
        appletContext.showDocument(url);
    }

    public static void showRelative(String relativePath) {
        Applet a = appletContext.getApplet(APPLET_NAME);
        if (a != null) {
            String uStr;
            int i;
            if (!relativePath.startsWith("/")) {
                relativePath = "/" + relativePath;
            }
            if ((i = (uStr = a.getCodeBase().toString()).indexOf("/applet")) != -1) {
                try {
                    URL url = new URL(uStr.substring(0, i) + relativePath);
                    appletContext.showDocument(url);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public static Applet getApplet() {
        return appletContext.getApplet(APPLET_NAME);
    }

    public int show(PlexiMessagePanel msgPanel, UserSelection uselection) {
        int rtn = 0;
        String imageViewerClassName = uselection.getImageViewerClass();
        try {
            Class[] intArgsClass = new Class[]{uselection.getClass()};
            Object[] intArgs = new Object[]{uselection};
            Class<?> imgViewerDefinition = Class.forName(imageViewerClassName);
            Constructor<?> intArgsConstructor = imgViewerDefinition.getConstructor(intArgsClass);
            PlexiImageViewerI imgViewer = (PlexiImageViewerI)CreateUtils.createObject(intArgsConstructor, intArgs);
            rtn = imgViewer.open(msgPanel);
            if (rtn != 0) {
                this.addToVector(imgViewer);
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
        }
        catch (NoSuchMethodException e) {
            System.out.println(e);
        }
        return rtn;
    }

    public static ImagePlus findImage(UserSelection uselection) {
        if (mrimages != null && !mrimages.isEmpty()) {
            for (int i = 0; i < mrimages.size(); ++i) {
                ImagePlus image;
                PlexiImageViewerI vectorEntry = (PlexiImageViewerI)mrimages.elementAt(i);
                if (!uselection.isIdentical(vectorEntry.getUserSelection()) || (image = ((PlexiImageViewerI)mrimages.elementAt(i)).getImagePlus()) == null) continue;
                return image;
            }
        }
        return null;
    }

    public void addImage(PlexiImageViewerI im) {
        mrimages.addElement(im);
    }

    public void getVectorSize() {
        System.out.println("PlexiManager:: I have " + mrimages.size() + " Number of elements");
    }

    public static void removeImage(PlexiImageViewerI im) {
        boolean ableToRemoveViewer = mrimages.removeElement(im);
        PlexiManager.decrementSegImageCount(im);
        System.out.println("Manager removed the viewer " + ableToRemoveViewer);
        im = null;
        mrimages.trimToSize();
        Runtime.getRuntime().gc();
    }

    public static synchronized void syncStacks(int x, int y, int z, float ipvalue, boolean slice, String fromView, boolean fromRadiologic, String fromCoordinateSystem, String exptType, String dataType) {
        if (mrimages == null) {
            return;
        }
        for (int i = 0; i < mrimages.size(); ++i) {
            PlexiImageViewerI mrimage = (PlexiImageViewerI)mrimages.elementAt(i);
            if (mrimage.getUserSelection().getProject().equals(exptType) && mrimage.getUserSelection().getDataType().equals(dataType) && mrimage.getLayout().getName().equalsIgnoreCase(fromCoordinateSystem)) {
                mrimage.adjustCoords(x, y, z, ipvalue, slice, fromView, fromRadiologic);
                continue;
            }
            System.out.println("The values dont match:" + exptType + ": " + mrimage.getUserSelection().getProject() + " " + mrimage.getUserSelection().getDataType() + " " + dataType);
        }
    }

    public static void syncSegStacks(int x, int y, int z, float ipvalue, String fromView, boolean fromRadiologic, String fromCoordinateSystem, String imageViewerClassName, int region, String regionName) {
        if (mrimages == null) {
            return;
        }
        for (int i = 0; i < mrimages.size(); ++i) {
            String imageViewerClass;
            PlexiImageViewerI mrimage = (PlexiImageViewerI)mrimages.elementAt(i);
            if (!mrimage.getLayout().getName().equalsIgnoreCase(fromCoordinateSystem) || !imageViewerClassName.equalsIgnoreCase(imageViewerClass = mrimage.getUserSelection().getImageViewerClass())) continue;
            mrimage.adjustRegions(x, y, z, ipvalue, true, regionName, fromRadiologic, region);
        }
    }

    private void addToVector(PlexiImageViewerI imgViewer) {
        Enumeration e = mrimages.elements();
        boolean exists = false;
        while (e.hasMoreElements()) {
            PlexiImageViewerI mrimage = (PlexiImageViewerI)e.nextElement();
            if (!imgViewer.getUserSelection().isIdentical(mrimage.getUserSelection())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            mrimages.addElement(imgViewer);
            PlexiManager.incrementSegImageCount(imgViewer);
        }
    }

    public static void decrementSegImageCount(PlexiImageViewerI imgViewer) {
        if (imgViewer instanceof org.nrg.plexiViewer.lite.viewer.Seg.SegImage || imgViewer instanceof org.nrg.plexiViewer.lite.viewer.MiriadEmSeg.SegImage || imgViewer instanceof SegImage || imgViewer instanceof org.nrg.plexiViewer.lite.viewer.MiriadMrxSeg.SegImage) {
            Integer cnt = (Integer)PlexiManager.getSetting("SegImageCount");
            int i = 0;
            if (cnt != null) {
                i = cnt - 1;
            }
            if (i == 0) {
                PlexiManager.setSetting("SegImage.regionID", new Integer(-1));
            }
            PlexiManager.setSetting("SegImageCount", new Integer(i));
        }
    }

    public static void incrementSegImageCount(PlexiImageViewerI imgViewer) {
        if (imgViewer instanceof org.nrg.plexiViewer.lite.viewer.Seg.SegImage || imgViewer instanceof org.nrg.plexiViewer.lite.viewer.MiriadEmSeg.SegImage || imgViewer instanceof SegImage || imgViewer instanceof org.nrg.plexiViewer.lite.viewer.MiriadMrxSeg.SegImage) {
            Integer cnt = (Integer)PlexiManager.getSetting("SegImageCount");
            int i = cnt == null ? 0 : cnt;
            PlexiManager.setSetting("SegImageCount", new Integer(i + 1));
        }
    }

    public static Object getSetting(String key) {
        Object rtn = null;
        if (viewerSettings.containsKey(key)) {
            rtn = viewerSettings.get(key);
        }
        return rtn;
    }

    public static void setSetting(String key, Object value) {
        viewerSettings.put(key, value);
    }

    static {
        controlKeys = true;
    }
}

