/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.tunneler;

import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.manager.PlexiImageViewerI;
import org.nrg.plexiViewer.lite.ui.LoadStatus;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;

public class ImageTunneler
implements Runnable {
    private URL dataURL;
    PlexiImageViewerI image;
    private String host;
    private URLConnection servletConnection;
    private boolean windowShowing;
    Thread queryRetriever;
    UserSelection userSelection;

    public ImageTunneler(PlexiImageViewerI image, String host) {
        this.image = image;
        this.host = host;
        this.windowShowing = false;
        this.userSelection = null;
    }

    private void openConnection() {
        String suffix = HTTPDetails.getSuffix("ImageDistributorServlet");
        try {
            this.dataURL = new URL(HTTPDetails.getProtocol(), HTTPDetails.getHost(), HTTPDetails.getPort(), suffix);
            this.servletConnection = this.dataURL.openConnection();
            this.servletConnection.setDoInput(true);
            this.servletConnection.setDoOutput(true);
            this.servletConnection.setUseCaches(false);
            this.servletConnection.setDefaultUseCaches(false);
            this.servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outStreamToServlet = new ObjectOutputStream(this.servletConnection.getOutputStream());
            outStreamToServlet.writeObject(this.userSelection);
            outStreamToServlet.flush();
            outStreamToServlet.close();
        }
        catch (MalformedURLException mfe) {
            mfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void load() {
        this.userSelection = (UserSelection)this.image.getUserSelection().clone();
        this.queryRetriever = new Thread((Runnable)this, "ImageTunneller");
        this.queryRetriever.start();
    }

    @Override
    public void run() {
        try {
            this.retrieveImage();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (OutOfMemoryError ome) {
            this.image.handleOutOfMemoryError();
        }
    }

    private void retrieveImage() throws IOException {
        this.openConnection();
        InputStream is = this.servletConnection.getInputStream();
        ObjectInputStream in = new ObjectInputStream(is);
        try {
            ImageProcessor ip;
            this.image.setMessage("Loading image:", "Receiving data...");
            LoadStatus status = (LoadStatus)in.readObject();
            if (!status.isSuccess()) {
                this.image.setMessage("Loading image:", "Error");
                this.image.setMessage("Error", "Unable to find the image");
                return;
            }
            int nSlices = status.getCount();
            int width = status.getDimensions().width;
            int height = status.getDimensions().height;
            this.image.setMessage("Loading image:", "Connected to server...");
            ImageStack stack = new ImageStack(width, height);
            ImagePlus mrip = this.image.getImagePlus();
            Calibration cal = mrip.getCalibration();
            if (this.userSelection.getFile().getVoxelResX() != -1.0) {
                cal.pixelWidth = this.userSelection.getFile().getVoxelResX();
            }
            if (this.userSelection.getFile().getVoxelResY() != -1.0) {
                cal.pixelHeight = this.userSelection.getFile().getVoxelResY();
            }
            if (this.userSelection.getFile().getVoxelResZ() != -1.0) {
                cal.pixelDepth = this.userSelection.getFile().getVoxelResZ();
            }
            MontageDisplay display = (MontageDisplay)in.readObject();
            for (int i = 0; i < nSlices; ++i) {
                Object pixels = in.readObject();
                stack.addSlice("", pixels);
                if (mrip != null) {
                    if (nSlices == 1) {
                        if (i == 0) {
                            mrip.setStack("", stack);
                            WindowManager.addWindow((Frame)mrip.getWindow());
                        }
                    } else if (i == 1) {
                        mrip.setStack("", stack);
                        WindowManager.addWindow((Frame)mrip.getWindow());
                    }
                    if (i > 0) {
                        mrip.setSlice(i);
                        ip = mrip.getProcessor();
                        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
                            ip.resetMinAndMax();
                        }
                        if (i > 1) {
                            try {
                                ((StackWindow)mrip.getWindow()).updateSliceSelector();
                            }
                            catch (ClassCastException cce) {
                                cce.printStackTrace();
                            }
                        }
                    }
                }
                if (this.image == null) continue;
                this.image.setMessage("Loading image:", "Slice " + (i + 1) + "/" + nSlices);
            }
            int midSlice = stack.getSize() / 2;
            if (midSlice == 0) {
                midSlice = 1;
            }
            mrip.setSlice(midSlice);
            ip = mrip.getProcessor();
            double min = ip.getMin();
            double max = ip.getMax();
            if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
                ip.resetMinAndMax();
            }
            ip.setMinAndMax(min, max);
            mrip.getProcessor().resetMinAndMax();
            mrip.updateAndDraw();
            mrip.setCalibration(cal);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (OutOfMemoryError ome) {
            this.image.handleOutOfMemoryError();
        }
        this.image.setMessage("Loading image:", "Complete");
        if (this.windowShowing) {
            this.image.setWaitCursor(false);
            this.image.getImagePlus().updateAndRepaintWindow();
        }
        in.close();
        is.close();
    }
}

