/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.ui;

import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.Vector;
import org.nrg.plexiViewer.lite.image.SerializableCalibration;

public class LoadStatus
implements Serializable {
    boolean success = false;
    Vector message;
    int nObjects = 0;
    Dimension dim;
    SerializableCalibration cal;
    int bytesPerPixel;

    public LoadStatus(boolean success, Vector message, int count, int w, int h, SerializableCalibration cal, int bPerPixel) {
        this.success = success;
        this.message = message;
        this.nObjects = count;
        this.dim = new Dimension(w, h);
        this.cal = cal;
        this.bytesPerPixel = bPerPixel;
    }

    public void setMessage(Vector message) {
        this.message = message;
    }

    public Vector getMessage() {
        return this.message;
    }

    public void setCount(int count) {
        this.nObjects = count;
    }

    public int getCount() {
        return this.nObjects;
    }

    public void setDimensions(Dimension d) {
        this.dim = d;
    }

    public Dimension getDimensions() {
        return this.dim;
    }

    public void setSuccess(boolean sucess) {
        this.success = this.success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String toString() {
        String str = "";
        str = str + "Success: " + this.success + "\n";
        str = str + "Slices: " + this.getCount() + "\n";
        str = str + "Width: " + this.getDimensions().width;
        str = str + "Height: " + this.getDimensions().height;
        str = str + "Calibration: " + this.cal.toString();
        str = str + "Messages: \n";
        for (int i = 0; i < this.getMessage().size(); ++i) {
            String message = (String)this.getMessage().elementAt(i);
            str = str + message + "\n";
        }
        return str;
    }

    public Calibration getCalibration() {
        Calibration rtn = null;
        if (this.cal != null) {
            rtn = this.cal.getCalibration();
        }
        return rtn;
    }

    public int getBytesPerPixel() {
        return this.bytesPerPixel;
    }

    public void setBytesPerPixel(int i) {
        this.bytesPerPixel = i;
    }

    public ImageProcessor getProcessor(int width, int height) {
        Object rtn = null;
        rtn = this.getBytesPerPixel() == 4 ? new FloatProcessor(width, height) : new ByteProcessor(width, height);
        return rtn;
    }

    public FileInfo getFileInfo() {
        FileInfo fi = new FileInfo();
        fi.fileType = this.getBytesPerPixel() == 4 ? 4 : 0;
        fi.fileFormat = 1;
        fi.width = this.dim.width;
        fi.height = this.dim.height;
        fi.nImages = this.getCount();
        fi.gapBetweenImages = 0;
        fi.intelByteOrder = false;
        return fi;
    }
}

