/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.nrg.plexiViewer.lite.gui.PlexiMessagePanel;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;

public class PlexiSubscriberClientProxy
extends Thread {
    PlexiMessagePanel msgPanel;
    boolean update = false;
    String opt;
    private URL dataURL;
    private URLConnection servletConnection;
    private boolean stop = false;
    private int inc;
    private boolean isConnected;

    public PlexiSubscriberClientProxy(PlexiMessagePanel mPanel, String opt) {
        this.opt = opt;
        this.msgPanel = mPanel;
        this.inc = 1;
        this.isConnected = false;
    }

    private void openConnection() {
        String suffix = HTTPDetails.getSuffix("PublisherServlet");
        try {
            this.dataURL = HTTPDetails.getURL(HTTPDetails.host, suffix);
            this.servletConnection = this.dataURL.openConnection();
            this.servletConnection.setDoInput(true);
            this.servletConnection.setDoOutput(true);
            this.servletConnection.setUseCaches(false);
            this.servletConnection.setDefaultUseCaches(false);
            this.servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outStreamToServlet = new ObjectOutputStream(this.servletConnection.getOutputStream());
            outStreamToServlet.writeObject(this.opt);
            outStreamToServlet.flush();
            outStreamToServlet.close();
        }
        catch (MalformedURLException mfe) {
            mfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                this.retrieveMessage();
                PlexiSubscriberClientProxy.sleep(40L);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    public void finish() {
        this.stop = true;
    }

    private void retrieveMessage() throws IOException {
        this.openConnection();
        InputStream is = this.servletConnection.getInputStream();
        ObjectInputStream in = new ObjectInputStream(is);
        try {
            Object message = in.readObject();
            this.msgPanel.setMessage((String)message);
        }
        catch (Exception e) {
            this.msgPanel.setMessage("");
        }
        is.close();
        in.close();
    }
}

