/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.viewer.MR;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import org.nrg.plexiViewer.lite.manager.PlexiManager;
import org.nrg.plexiViewer.lite.viewer.MR.MRImage;
import org.nrg.plexiViewer.lite.viewer.MR.MRMontageWindow;
import org.nrg.plexiViewer.lite.viewer.MR.MRStackWindow;
import org.nrg.plexiViewer.lite.viewer.MR.MRWindow;

public class MRCanvas
extends ImageCanvas {
    MRImage mrimage;
    int startX;
    int startY;
    int xhandled;
    int yhandled;
    private boolean syncFlag;
    int crosshairX = -1;
    int crosshairY = -1;
    Image buffer;
    Graphics bufferGraphics;

    public MRCanvas(MRImage mrimage) {
        super(mrimage.getImagePlus());
        this.mrimage = mrimage;
        int scale = mrimage.getScale();
        int height = mrimage.getImagePlus().getHeight();
        int width = mrimage.getImagePlus().getWidth();
        super.setDrawingSize(width * scale, height * scale);
        this.setSize(width * scale, height * scale);
        System.out.println("Montage Scale is " + scale);
    }

    public void paint(Graphics g) {
        String s = this.mrimage.getOrientation().equalsIgnoreCase("sagittal") ? "" : (this.mrimage.getRadiologic() ? "L" : "R");
        Rectangle r = super.getSrcRect();
        int scale = this.mrimage.getScale();
        ImagePlus ip = this.mrimage.getImagePlus();
        if (ip == null) {
            return;
        }
        if (this.bufferGraphics == null) {
            this.buffer = this.createImage(r.width * scale, r.height * scale);
            this.bufferGraphics = this.buffer.getGraphics();
        }
        this.bufferGraphics.setColor(Color.black);
        this.bufferGraphics.fillRect(0, 0, r.width * scale, r.height * scale);
        ip.updateImage();
        Image img = ip.getImage();
        if (img != null) {
            Point dst2 = new Point(r.width * scale, r.height * scale);
            Point src1 = new Point(r.x, r.y);
            Point src2 = new Point(r.x + r.width, r.y + r.height);
            this.bufferGraphics.drawImage(img, 0, 0, dst2.x, dst2.y, src1.x, src1.y, src2.x, src2.y, null);
        }
        try {
            ImageWindow window = ip.getWindow();
            MRStackWindow mrstack = null;
            MRMontageWindow montageWindow = null;
            if (window instanceof MRStackWindow) {
                mrstack = (MRStackWindow)window;
            } else if (window instanceof MRMontageWindow) {
                montageWindow = (MRMontageWindow)window;
            }
            if (mrstack != null && mrstack.markRight() || montageWindow != null && montageWindow.markRight()) {
                this.bufferGraphics.setColor(new Color(50, 200, 25));
                this.bufferGraphics.drawString(s, r.width * scale - 20, r.height * scale - 10);
            }
            if (mrstack != null && mrstack.showRuler() || montageWindow != null && montageWindow.showRuler()) {
                this.bufferGraphics.setColor(new Color(225, 225, 225));
                this.bufferGraphics.drawLine(10 * scale, r.height * scale - 10, 60 * scale, r.height * scale - 10);
                this.bufferGraphics.drawLine(10 * scale, r.height * scale - 10, 10 * scale, r.height * scale - 15);
                this.bufferGraphics.drawLine(15 * scale, r.height * scale - 10, 15 * scale, r.height * scale - 12);
                this.bufferGraphics.drawLine(20 * scale, r.height * scale - 10, 20 * scale, r.height * scale - 15);
                this.bufferGraphics.drawLine(25 * scale, r.height * scale - 10, 25 * scale, r.height * scale - 12);
                this.bufferGraphics.drawLine(30 * scale, r.height * scale - 10, 30 * scale, r.height * scale - 15);
                this.bufferGraphics.drawLine(35 * scale, r.height * scale - 10, 35 * scale, r.height * scale - 12);
                this.bufferGraphics.drawLine(40 * scale, r.height * scale - 10, 40 * scale, r.height * scale - 15);
                this.bufferGraphics.drawLine(45 * scale, r.height * scale - 10, 45 * scale, r.height * scale - 12);
                this.bufferGraphics.drawLine(50 * scale, r.height * scale - 10, 50 * scale, r.height * scale - 15);
                this.bufferGraphics.drawLine(55 * scale, r.height * scale - 10, 55 * scale, r.height * scale - 12);
                this.bufferGraphics.drawLine(60 * scale, r.height * scale - 10, 60 * scale, r.height * scale - 15);
            }
            if (mrstack != null && mrstack.showCrossHair() || montageWindow != null && montageWindow.showCrossHair()) {
                this.bufferGraphics.setColor(new Color(100, 255, 50));
                double space = 5.0;
                this.bufferGraphics.drawLine(0, this.crosshairY, this.crosshairX - (int)space, this.crosshairY);
                this.bufferGraphics.drawLine(this.crosshairX + (int)space, this.crosshairY, this.getBounds().width * scale, this.crosshairY);
                this.bufferGraphics.drawLine(this.crosshairX, 0, this.crosshairX, this.crosshairY - (int)space);
                this.bufferGraphics.drawLine(this.crosshairX, this.crosshairY + (int)space, this.crosshairX, scale * this.getBounds().height);
            }
        }
        catch (ClassCastException e) {
            System.out.println("Exception thrown " + e);
        }
        g.drawImage(this.buffer, 0, 0, (ImageObserver)((Object)this));
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            roi.draw(g);
        }
    }

    public Dimension getPreferredSize() {
        int scale = this.mrimage.getScale();
        int height = this.mrimage.getImagePlus().getHeight();
        int width = this.mrimage.getImagePlus().getWidth();
        return new Dimension(width * scale, height * scale);
    }

    public void mousePressed(MouseEvent e) {
        if (!PlexiManager.controlKeys) {
            super.mousePressed(e);
        } else {
            Point p = e.getPoint();
            this.startX = p.x;
            this.startY = p.y;
            this.xhandled = 0;
            this.yhandled = 0;
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (!PlexiManager.controlKeys) {
            super.mouseClicked(e);
        } else {
            Point p = e.getPoint();
            if (this.mrimage != null) {
                this.mrimage.setCoords(p.x, p.y);
                this.mrimage.printCoords();
                this.mrimage.syncEvent(p.x, p.y, true);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!PlexiManager.controlKeys) {
            super.mouseReleased(e);
        } else {
            this.mrimage.printCoords();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!PlexiManager.controlKeys) {
            super.mouseMoved(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!PlexiManager.controlKeys) {
            super.mouseDragged(e);
        } else {
            ImagePlus imp = this.mrimage.getImagePlus();
            if (imp.lockSilently()) {
                return;
            }
            Point p = e.getPoint();
            ImageProcessor ip = imp.getProcessor();
            int xdist = p.x - this.startX;
            int xincr = xdist - this.xhandled;
            this.xhandled = xdist;
            int ydist = p.y - this.startY;
            int yincr = ydist - this.yhandled;
            this.yhandled = ydist;
            this.adjustBrightness(ip, xincr);
            this.adjustContrast(ip, yincr);
            imp.updateAndDraw();
            MRWindow win = (MRWindow)imp.getWindow();
            win.setMessage("Range: ", (int)ip.getMin() + " to " + (int)ip.getMax());
            win.message();
        }
    }

    void adjustBrightness(ImageProcessor ip, double bvalue) {
        double min = ip.getMin();
        double max = ip.getMax();
        ip.setMinAndMax(min - bvalue, max - bvalue);
        if (min == max) {
            this.setThreshold(ip);
        }
    }

    void adjustContrast(ImageProcessor ip, int cvalue) {
        double min = ip.getMin();
        double max = ip.getMax();
        double center = (min + max) / 2.0;
        double range = max - min;
        if ((range += (double)(4 * cvalue)) < 2.0) {
            range = 2.0;
        }
        ip.setMinAndMax(center - range / 2.0, center + range / 2.0);
    }

    void setThreshold(ImageProcessor ip) {
        if (!(ip instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)ip).isInvertedLut()) {
            ip.setThreshold(255.0, 255.0, 2);
        } else {
            ip.setThreshold(0.0, 255.0, 2);
        }
    }

    void setCrosshairPosition(int x, int y) {
        this.crosshairX = x;
        this.crosshairY = y;
    }

    public void setCursor(int x, int y) {
    }
}

