/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.viewer.MiriadEmSeg;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import org.nrg.plexiViewer.lite.manager.PlexiManager;
import org.nrg.plexiViewer.lite.viewer.MiriadEmSeg.SegCanvas;
import org.nrg.plexiViewer.lite.viewer.MiriadEmSeg.SegStackWindow;
import org.nrg.plexiViewer.lite.viewer.MiriadEmSeg.SmallLabel;

public class ToolPanel
extends Panel
implements ActionListener,
ItemListener {
    int currentSelection;
    SmallLabel regionLabel;
    SmallLabel coordsLabel;
    SmallLabel volCountLabel;
    SmallLabel volCountText;
    SmallLabel msgLabel;
    Panel scalePanel;
    Hashtable rm = new Hashtable();
    Hashtable rm2;
    Choice displayChoice;

    public ToolPanel() {
        this.rm.put("0", "0-clear");
        this.rm.put("1", "1-air");
        this.rm.put("2", "2-non-brain");
        this.rm.put("3", "3-brain");
        this.rm.put("4", "4-csf");
        this.rm.put("5", "5-gray");
        this.rm.put("6", "6-white");
        this.rm.put("7", "7-white norm");
        this.rm.put("8", "8-white lesion");
        this.rm.put("9", "9-other gray");
        this.rm.put("10", "10-LAmygdala");
        this.rm.put("11", "11-RAmygdala");
        this.rm.put("12", "12-LAntInsCortex");
        this.rm.put("13", "13-RAntInsCortex");
        this.rm.put("14", "14-LHippocampus");
        this.rm.put("15", "15-RHippocampus");
        this.rm.put("16", "16-LInfTempGyrus");
        this.rm.put("17", "17-RInfTempGyrus");
        this.rm.put("18", "18-LMidTempGyrus");
        this.rm.put("19", "19-RMidTempGyrus");
        this.rm.put("20", "20-LParahippocampus");
        this.rm.put("21", "21-RParahippocampus");
        this.rm.put("22", "22-LPostInsCortex");
        this.rm.put("23", "23-RPostInsCortex");
        this.rm.put("24", "24-LSupTempGyrus");
        this.rm.put("25", "25-RSupTempGyrus");
        this.rm.put("26", "26-LTempLobe");
        this.rm.put("27", "27-RTempLobe");
        this.rm.put("28", "28-LThalamus");
        this.rm.put("29", "29-RThalamus");
        this.rm2 = new Hashtable();
        this.rm2.put("0-clear", "0");
        this.rm2.put("1-air", "1");
        this.rm2.put("2-non-brain", "2");
        this.rm2.put("3-brain", "3");
        this.rm2.put("4-csf", "4");
        this.rm2.put("5-gray", "5");
        this.rm2.put("6-white", "6");
        this.rm2.put("7-white norm", "7");
        this.rm2.put("8-white lesion", "8");
        this.rm2.put("9-other gray", "9");
        this.rm2.put("10-LAmygdala", "10");
        this.rm2.put("11-RAmygdala", "11");
        this.rm2.put("12-LAntInsCortex", "12");
        this.rm2.put("13-RAntInsCortex", "13");
        this.rm2.put("14-LHippocampus", "14");
        this.rm2.put("15-RHippocampus", "15");
        this.rm2.put("16-LInfTempGyrus", "16");
        this.rm2.put("17-RInfTempGyrus", "17");
        this.rm2.put("18-LMidTempGyrus", "18");
        this.rm2.put("19-RMidTempGyrus", "19");
        this.rm2.put("20-LParahippocampus", "20");
        this.rm2.put("21-RParahippocampus", "21");
        this.rm2.put("22-LPostInsCortex", "22");
        this.rm2.put("23-RPostInsCortex", "23");
        this.rm2.put("24-LSupTempGyrus", "24");
        this.rm2.put("25-RSupTempGyrus", "25");
        this.rm2.put("26-LTempLobe", "26");
        this.rm2.put("27-RTempLobe", "27");
        this.rm2.put("28-LThalamus", "28");
        this.rm2.put("29-RThalamus", "29");
        this.initAddComponents();
    }

    private void initAddComponents() {
        this.setLayout(new GridBagLayout());
        this.setFont(new Font("Dialog", 0, 11));
        this.setForeground(Color.black);
        this.coordsLabel = new SmallLabel(90, 18);
        this.coordsLabel.setText("");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.add((Component)this.coordsLabel, gbc);
        this.regionLabel = new SmallLabel(90, 18);
        this.regionLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.add((Component)this.regionLabel, gbc);
        SmallLabel l = new SmallLabel(44, 18);
        l.setAlignment(0);
        l.setText("Display:   ");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)l, gbc);
        this.displayChoice = new Choice();
        this.displayChoice.setFont(new Font("Dialog", 0, 10));
        this.displayChoice.addItem("All Regions");
        for (int i = 0; i < 140; ++i) {
            if (!this.rm.containsKey(Integer.toString(i))) continue;
            this.displayChoice.addItem((String)this.rm.get(Integer.toString(i)));
        }
        this.displayChoice.addItemListener(this);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add((Component)this.displayChoice, gbc);
        this.volCountText = new SmallLabel(44, 18);
        this.volCountText.setAlignment(0);
        this.volCountText.setText("Vol.Cnt: ");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.add((Component)this.volCountText, gbc);
        this.volCountLabel = new SmallLabel(88, 18);
        this.volCountLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.add((Component)this.volCountLabel, gbc);
        this.msgLabel = new SmallLabel(200, 18);
        this.msgLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.add((Component)this.msgLabel, gbc);
        System.out.println("Seg::ToolPanel Constructor called " + PlexiManager.getSetting("SegImage.regionID"));
        System.out.println("Seg::ToolPanel Selected Index " + this.displayChoice.getSelectedIndex() + "   " + this.displayChoice.getSelectedItem());
    }

    public void setVolumeCount(String r) {
        this.volCountLabel.setText(r);
    }

    public void setRegion(int r) {
        String s = (String)this.rm.get(Integer.toString(r));
        this.regionLabel.setText(s);
        SegCanvas c = (SegCanvas)((SegStackWindow)((Object)this.getParent())).getCanvas();
        this.setVolumeCount(c.getVolumeCount(r));
    }

    public void setCoords(int x, int y, int z) {
        String s = Integer.toString(x) + ", " + Integer.toString(y) + ", " + Integer.toString(z) + ": ";
        this.coordsLabel.setText(s);
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public int getCurrentSelection() {
        return this.currentSelection;
    }

    public void setRegionName(int regionId) {
        int currentRegionId = (Integer)PlexiManager.getSetting("SegImage.regionID");
        System.out.println("ToolPanle::setRegionName " + currentRegionId);
        if (currentRegionId == -1) {
            this.displayChoice.select(0);
        } else {
            this.displayChoice.select(currentRegionId);
            try {
                SegCanvas c = (SegCanvas)((SegStackWindow)((Object)this.getParent())).getCanvas();
                this.setVolumeCount(c.getVolumeCount(currentRegionId));
            }
            catch (Exception e) {
                System.out.println("ToolPanel setRegionName cought exception ");
            }
            System.out.println("End of toolpanel setRegionName");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.displayChoice) {
            String s = this.displayChoice.getSelectedItem();
            int r = -1;
            System.out.println("ToolPanel::itemStateChanged Region Name" + s);
            if (!s.equals("All Regions")) {
                String rn = (String)this.rm2.get(s);
                try {
                    r = Integer.parseInt(rn);
                    System.out.println("ToolPanel::itemStateChanged Region Name" + rn + " Region No " + r);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            SegStackWindow w = (SegStackWindow)((Object)this.getParent());
            SegCanvas c = (SegCanvas)w.getCanvas();
            c.setCmRegion(r);
            this.setVolumeCount(c.getVolumeCount(r));
            w.getSegImage().syncRegions(r, s);
            PlexiManager.setSetting("SegImage.regionID", new Integer(r));
        }
    }

    public void flush() {
        this.rm.clear();
        this.rm2.clear();
        this.rm = null;
        this.rm2 = null;
        this.displayChoice.removeItemListener(this);
    }

    public void setVolumeCntVisible(boolean bool) {
        this.volCountLabel.setVisible(bool);
        this.volCountText.setVisible(bool);
    }

    public void setMessage(String msg) {
        this.msgLabel.setText(msg);
    }
}

