/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.viewer.Seg;

import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import org.nrg.plexiViewer.lite.manager.PlexiManager;
import org.nrg.plexiViewer.lite.ui.PlexiMenuBar;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;
import org.nrg.plexiViewer.lite.viewer.Seg.SegCanvas;
import org.nrg.plexiViewer.lite.viewer.Seg.SegImage;
import org.nrg.plexiViewer.lite.viewer.Seg.ToolPanel;

public class SegStackWindow
extends StackWindow {
    SegCanvas segCanvas;
    private static final int TEXT_GAP = 0;
    public SegImage _image;
    private String messageStr = "";
    private String descripStr = "";
    ToolPanel tp;
    private PlexiMenuBar pMenuBar;

    public SegStackWindow(SegImage image, SegCanvas canvas) {
        super(image.getStrImage(), (ImageCanvas)canvas);
        this.segCanvas = canvas;
        this._image = image;
        if (this._image.getDisplay().equalsIgnoreCase("MONTAGE")) {
            this.sliceSelector.setVisible(false);
        }
        this.setBackground(Color.lightGray);
        this.tp = new ToolPanel();
        if (this._image.getDisplay().equalsIgnoreCase("MONTAGE")) {
            this.tp.setVolumeCntVisible(false);
        }
        this.add(this.tp);
        this.tp.setRegionName((Integer)PlexiManager.getSetting("SegImage.regionID"));
        System.out.println("Seg::SegStackWindow Selected Index " + this.tp.displayChoice.getSelectedIndex() + "   " + this.tp.displayChoice.getSelectedItem());
        this.pMenuBar = new PlexiMenuBar((ImageWindow)this, HTTPDetails.getHost(), this._image.getUserSelection());
        this.setMenuBar(this.pMenuBar.getMenuBar());
        this.pack();
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        super.adjustmentValueChanged(e);
        if (this._image != null) {
            this._image.setCoordBySlice();
        }
    }

    public void updateSliceSelector() {
        if (this._image == null) {
            return;
        }
        super.updateSliceSelector();
        if (this._image != null) {
            this._image.setCoordBySlice();
        } else {
            System.out.println("Seg StackWindow: mrimage is null");
        }
    }

    public void showSlice(int index) {
        if (index >= 1 && index <= this._image.getStrImage().getStackSize()) {
            this._image.getStrImage().setSlice(index);
            this._image.getAsegImage().setSlice(index);
        }
    }

    public void setVolumeCount(String i) {
        this.tp.setVolumeCount(i);
    }

    public void setRegion(int i) {
        this.tp.setRegion(i);
    }

    public void setCoords(int x, int y, int z) {
        this.tp.setCoords(x, y, z);
    }

    public void focusGained(FocusEvent e) {
    }

    public SegStackWindow getWindow() {
        return this;
    }

    public void doRescale(int s) {
        this._image.rescale(s);
    }

    public void setMessage(String messageStr) {
        if (this.tp != null) {
            this.tp.setMessage(messageStr);
        }
    }

    public void setSelectorToSlice() {
        this.sliceSelector.setValue(this._image.getStrImage().getCurrentSlice());
        if (this._image.getOrientation().equalsIgnoreCase("transverse")) {
            int selected = this.sliceSelector.getValue();
            this.slice = this.sliceSelector.getMaximum() - selected;
            this.sliceSelector.setValue(this.slice);
        }
    }

    public void updateCrosshairs(int x, int y) {
        this.segCanvas.setCrosshairPosition(x, y);
        this.segCanvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        SegStackWindow segStackWindow = this;
        synchronized (segStackWindow) {
            this.done = true;
            ((Object)((Object)this)).notify();
        }
    }

    public boolean close() {
        this.segCanvas.setVolumeCount(null);
        this.tp.flush();
        super.close();
        this.pMenuBar = null;
        this._image.getImagePlus().flush();
        this._image.getAsegImage().flush();
        return true;
    }

    public void windowClosing(WindowEvent e) {
        this.pMenuBar.clear();
        this.close();
        this._image.windowClosing();
    }

    public void windowActivated(WindowEvent e) {
        SegStackWindow win = this;
        win.getCanvas().setMagnification((double)this._image.getScale());
    }

    public SegImage getSegImage() {
        return this._image;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        int TEXT_GAP = 10;
        return new Insets(insets.top - TEXT_GAP, insets.left, insets.bottom, insets.right);
    }

    public void drawInfo(Graphics g) {
    }

    public boolean showCrossHair() {
        boolean rtn = true;
        if (this.pMenuBar != null) {
            rtn = this.pMenuBar.showCrossHair();
        }
        return rtn;
    }

    public boolean showRuler() {
        boolean rtn = true;
        if (this._image.getLayout() != null && !this._image.getLayout().getName().equalsIgnoreCase("native")) {
            if (this.pMenuBar != null) {
                rtn = this.pMenuBar.showRuler();
            }
        } else {
            rtn = false;
        }
        return rtn;
    }

    public boolean markRight() {
        boolean rtn = true;
        if (this.pMenuBar != null) {
            rtn = this.pMenuBar.markRight();
        }
        return rtn;
    }
}

