/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.viewer.Seg;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import org.nrg.plexiViewer.lite.manager.PlexiManager;
import org.nrg.plexiViewer.lite.viewer.Seg.SegCanvas;
import org.nrg.plexiViewer.lite.viewer.Seg.SegStackWindow;
import org.nrg.plexiViewer.lite.viewer.Seg.SmallLabel;

public class ToolPanel
extends Panel
implements ActionListener,
ItemListener {
    int currentSelection;
    SmallLabel regionLabel;
    SmallLabel coordsLabel;
    SmallLabel volCountLabel;
    SmallLabel volCountText;
    SmallLabel msgLabel;
    Panel scalePanel;
    Hashtable rm = new Hashtable();
    Hashtable rm2;
    Choice displayChoice;

    public ToolPanel() {
        this.rm.put("0", "Unknown");
        this.rm.put("2", "L-Cerebral-WM");
        this.rm.put("3", "L-Cerebral-Cortex");
        this.rm.put("4", "L-Lat-Vent");
        this.rm.put("5", "L-Inf-Lat-Vent");
        this.rm.put("7", "L-Cerebellum-WM");
        this.rm.put("8", "L-Cerebellum-Cortex");
        this.rm.put("10", "L-Thalamus-Proper");
        this.rm.put("11", "L-Caudate");
        this.rm.put("12", "L-Putamen");
        this.rm.put("13", "L-Pallidum");
        this.rm.put("14", "3rd-Ventricle");
        this.rm.put("15", "4th-Ventricle");
        this.rm.put("16", "Brain-Stem");
        this.rm.put("17", "L-Hippocampus");
        this.rm.put("18", "L-Amygdala");
        this.rm.put("24", "CSF");
        this.rm.put("26", "L-Accumbens-area");
        this.rm.put("28", "L-VentralDC");
        this.rm.put("30", "L-vessel");
        this.rm.put("41", "R-Cerebral-WM");
        this.rm.put("42", "R-Cerebral-Cortex");
        this.rm.put("43", "R-Lat-Vent");
        this.rm.put("44", "R-Inf-Lat-Vent");
        this.rm.put("46", "R-Cerebellum-WM");
        this.rm.put("47", "R-Cerebellum-Cortex");
        this.rm.put("49", "R-Thalamus-Proper");
        this.rm.put("50", "R-Caudate");
        this.rm.put("51", "R-Putamen");
        this.rm.put("52", "R-Pallidum");
        this.rm.put("53", "R-Hippocampus");
        this.rm.put("54", "R-Amygdala");
        this.rm.put("58", "R-Accumbens-area");
        this.rm.put("60", "R-VentralDC");
        this.rm.put("62", "R-vessel");
        this.rm.put("72", "5th-Ventricle");
        this.rm.put("77", "WM-hypointens");
        this.rm.put("78", "L-WM-hypointens");
        this.rm.put("79", "R-WM-hypointens");
        this.rm.put("80", "non-WM-hypointens");
        this.rm.put("85", "Optic-Chiasm");
        this.rm2 = new Hashtable();
        this.rm2.put("Unknown", "0");
        this.rm2.put("L-Cerebral-WM", "2");
        this.rm2.put("L-Cerebral-Cortex", "3");
        this.rm2.put("L-Lat-Vent", "4");
        this.rm2.put("L-Inf-Lat-Vent", "5");
        this.rm2.put("L-Cerebellum-WM", "7");
        this.rm2.put("L-Cerebellum-Cortex", "8");
        this.rm2.put("L-Thalamus-Proper", "10");
        this.rm2.put("L-Caudate", "11");
        this.rm2.put("L-Putamen", "12");
        this.rm2.put("L-Pallidum", "13");
        this.rm2.put("3rd-Ventricle", "14");
        this.rm2.put("4th-Ventricle", "15");
        this.rm2.put("Brain-Stem", "16");
        this.rm2.put("L-Hippocampus", "17");
        this.rm2.put("L-Amygdala", "18");
        this.rm2.put("CSF", "24");
        this.rm2.put("L-Accumbens-area", "26");
        this.rm2.put("L-VentralDC", "28");
        this.rm2.put("L-vessel", "30");
        this.rm2.put("R-Cerebral-WM", "41");
        this.rm2.put("R-Cerebral-Cortex", "42");
        this.rm2.put("R-Lat-Vent", "43");
        this.rm2.put("R-Inf-Lat-Vent", "44");
        this.rm2.put("R-Cerebellum-WM", "46");
        this.rm2.put("R-Cerebellum-Cortex", "47");
        this.rm2.put("R-Thalamus-Proper", "49");
        this.rm2.put("R-Caudate", "50");
        this.rm2.put("R-Putamen", "51");
        this.rm2.put("R-Pallidum", "52");
        this.rm2.put("R-Hippocampus", "53");
        this.rm2.put("R-Amygdala", "54");
        this.rm2.put("R-Accumbens-area", "58");
        this.rm2.put("R-VentralDC", "60");
        this.rm2.put("R-vessel", "62");
        this.rm2.put("5th-Ventricle", "72");
        this.rm2.put("WM-hypointens", "77");
        this.rm2.put("L-WM-hypointens", "78");
        this.rm2.put("R-WM-hypointens", "79");
        this.rm2.put("non-WM-hypointens", "80");
        this.rm2.put("Optic-Chiasm", "85");
        this.initAddComponents();
    }

    private void initAddComponents() {
        this.setLayout(new GridBagLayout());
        this.setFont(new Font("Dialog", 0, 11));
        this.setForeground(Color.black);
        this.coordsLabel = new SmallLabel(90, 18);
        this.coordsLabel.setText("");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.add((Component)this.coordsLabel, gbc);
        this.regionLabel = new SmallLabel(90, 18);
        this.regionLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.add((Component)this.regionLabel, gbc);
        SmallLabel l = new SmallLabel(44, 18);
        l.setAlignment(0);
        l.setText("Display:   ");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)l, gbc);
        this.displayChoice = new Choice();
        this.displayChoice.setFont(new Font("Dialog", 0, 10));
        this.displayChoice.addItem("All Regions");
        for (int i = 0; i < 140; ++i) {
            if (!this.rm.containsKey(Integer.toString(i))) continue;
            this.displayChoice.addItem((String)this.rm.get(Integer.toString(i)));
        }
        this.displayChoice.addItemListener(this);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add((Component)this.displayChoice, gbc);
        this.volCountText = new SmallLabel(44, 18);
        this.volCountText.setAlignment(0);
        this.volCountText.setText("Vol.Cnt: ");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.add((Component)this.volCountText, gbc);
        this.volCountLabel = new SmallLabel(88, 18);
        this.volCountLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.add((Component)this.volCountLabel, gbc);
        this.msgLabel = new SmallLabel(200, 18);
        this.msgLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.add((Component)this.msgLabel, gbc);
        System.out.println("Seg::ToolPanel Constructor called " + PlexiManager.getSetting("SegImage.regionID"));
        System.out.println("Seg::ToolPanel Selected Index " + this.displayChoice.getSelectedIndex() + "   " + this.displayChoice.getSelectedItem());
    }

    public void setVolumeCount(String r) {
        this.volCountLabel.setText(r);
    }

    public void setRegion(int r) {
        String s = (String)this.rm.get(Integer.toString(r));
        this.regionLabel.setText(s);
        SegCanvas c = (SegCanvas)((SegStackWindow)((Object)this.getParent())).getCanvas();
        this.setVolumeCount(c.getVolumeCount(r));
    }

    public void setCoords(int x, int y, int z) {
        String s = Integer.toString(x) + ", " + Integer.toString(y) + ", " + Integer.toString(z) + ": ";
        this.coordsLabel.setText(s);
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
    }

    public int getCurrentSelection() {
        return this.currentSelection;
    }

    public void setRegionName(int regionId) {
        int currentRegionId = (Integer)PlexiManager.getSetting("SegImage.regionID");
        System.out.println("ToolPanle::setRegionName " + currentRegionId);
        if (currentRegionId == -1) {
            this.displayChoice.select(0);
        } else {
            this.displayChoice.select(currentRegionId);
            try {
                SegCanvas c = (SegCanvas)((SegStackWindow)((Object)this.getParent())).getCanvas();
                this.setVolumeCount(c.getVolumeCount(currentRegionId));
            }
            catch (Exception e) {
                System.out.println("ToolPanel setRegionName cought exception ");
            }
            System.out.println("End of toolpanel setRegionName");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.displayChoice) {
            String s = this.displayChoice.getSelectedItem();
            int r = -1;
            System.out.println("ToolPanel::itemStateChanged Region Name" + s);
            if (!s.equals("All Regions")) {
                String rn = (String)this.rm2.get(s);
                try {
                    r = Integer.parseInt(rn);
                    System.out.println("ToolPanel::itemStateChanged Region Name" + rn + " Region No " + r);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            SegStackWindow w = (SegStackWindow)((Object)this.getParent());
            SegCanvas c = (SegCanvas)w.getCanvas();
            c.setCmRegion(r);
            this.setVolumeCount(c.getVolumeCount(r));
            w.getSegImage().syncRegions(r, s);
            PlexiManager.setSetting("SegImage.regionID", new Integer(r));
        }
    }

    public void flush() {
        this.rm.clear();
        this.rm2.clear();
        this.rm = null;
        this.rm2 = null;
        this.displayChoice.removeItemListener(this);
    }

    public void setVolumeCntVisible(boolean bool) {
        this.volCountLabel.setVisible(bool);
        this.volCountText.setVisible(bool);
    }

    public void setMessage(String msg) {
        this.msgLabel.setText(msg);
    }
}

