/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.xml;

import java.awt.Rectangle;
import java.io.Serializable;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;

public class CropDetails
implements Serializable,
Cloneable {
    int startSlice = -1;
    int endSlice = -1;
    Rectangle boundingRectangle = new Rectangle(-1, -1, -1, -1);

    public void setDimensions(PlexiImageFile pf) {
        if (this.crop()) {
            int dimZ = pf.getDimZ();
            int sSlice = 1;
            int eSlice = dimZ;
            if (this.startSlice != -1 && this.endSlice == -1) {
                sSlice = this.startSlice;
            } else if (this.endSlice != -1 && this.startSlice == -1) {
                eSlice = this.endSlice;
            } else if (this.endSlice != -1 && this.startSlice != -1) {
                sSlice = this.startSlice;
                eSlice = this.endSlice;
            }
            dimZ = this.endSlice - this.startSlice + 1;
            pf.setDimensions(this.boundingRectangle.width, this.boundingRectangle.height, dimZ);
        }
    }

    public Rectangle getBoundingRectangle() {
        return this.boundingRectangle;
    }

    public int getEndSlice() {
        return this.endSlice;
    }

    public int getStartSlice() {
        return this.startSlice;
    }

    public void setBoundingRectangle(int x, int y, int width, int height) {
        this.boundingRectangle = new Rectangle(x, y, width, height);
    }

    public void setBoundingRectangle(Rectangle rectangle) {
        this.boundingRectangle = rectangle;
    }

    public void setEndSlice(int i) {
        this.endSlice = i;
    }

    public void setStartSlice(int i) {
        this.startSlice = i;
    }

    public boolean deleteSlices() {
        boolean rtn = false;
        if (this.startSlice != -1 || this.endSlice != -1) {
            rtn = true;
        }
        return rtn;
    }

    public boolean crop() {
        boolean rtn = false;
        if (this.boundingRectangle.x != -1 && this.boundingRectangle.y != -1 && this.boundingRectangle.width != -1 && this.boundingRectangle.height != -1) {
            rtn = true;
        }
        return rtn;
    }

    public String toString() {
        String rtn = "Crop Details:\n";
        rtn = rtn + "\t\t Start Slice: " + this.startSlice + "\n";
        rtn = rtn + "\t\t End Slice: " + this.endSlice + "\n";
        rtn = rtn + "\t\t Bounding Rectangle: " + this.boundingRectangle.toString();
        rtn = rtn + "\n";
        return rtn;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

