/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.manager;

import java.util.Hashtable;
import org.nrg.plexiViewer.utils.PlexiPublisher;
import org.nrg.plexiViewer.utils.PlexiSubscriberProxy;

public class PlexiStatusPublisherManager {
    private Hashtable optionsPublisherHash = new Hashtable();
    private Hashtable optionsSubscriberHash = new Hashtable();
    private Hashtable optionsHandledHash = new Hashtable();
    private static PlexiStatusPublisherManager self = null;

    private PlexiStatusPublisherManager() {
    }

    public static PlexiStatusPublisherManager GetInstance() {
        if (self == null) {
            self = new PlexiStatusPublisherManager();
        }
        return self;
    }

    public void createPublisher(String opt) {
        if (this.optionsPublisherHash == null || this.optionsPublisherHash.size() == 0) {
            this.optionsPublisherHash.put(opt, new PlexiPublisher());
        } else if (!this.optionsPublisherHash.containsKey(opt)) {
            this.optionsPublisherHash.put(opt, new PlexiPublisher());
        }
    }

    public void createSubscriber(String opt) {
        if (this.optionsSubscriberHash == null || this.optionsSubscriberHash.size() == 0) {
            this.optionsSubscriberHash.put(opt, new PlexiSubscriberProxy(opt));
        } else if (!this.optionsSubscriberHash.containsKey(opt)) {
            this.optionsSubscriberHash.put(opt, new PlexiSubscriberProxy(opt));
        }
        this.optionsHandledHash.put(opt, new Boolean(false));
    }

    public PlexiPublisher getPublisher(String options) {
        return (PlexiPublisher)this.optionsPublisherHash.get(options);
    }

    public void removePublisher(String opt) {
        if (this.optionsPublisherHash.containsKey(opt)) {
            this.optionsPublisherHash.remove(opt);
        }
    }

    public PlexiSubscriberProxy getSubscriberProxy(String opt) {
        PlexiSubscriberProxy rtn = (PlexiSubscriberProxy)this.optionsSubscriberHash.get(opt);
        return rtn;
    }

    public void setHandled(String opt) {
        if (this.optionsHandledHash.containsKey(opt)) {
            this.optionsHandledHash.remove(opt);
        }
        this.optionsHandledHash.put(opt, new Boolean(true));
    }

    public Object isHandled(String opt) {
        return this.optionsHandledHash.get(opt);
    }

    public void clearHandledStatus() {
        this.optionsHandledHash = new Hashtable();
    }

    public void removeSubscriberProxy(String opt) {
        if (this.optionsSubscriberHash.containsKey(opt)) {
            this.optionsSubscriberHash.remove(opt);
        }
        if (this.optionsHandledHash.containsKey(opt)) {
            this.optionsHandledHash.remove(opt);
        }
    }
}

