/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nrg.plexiViewer.lite.DBFSXMLInfo;
import org.nrg.xdat.XDAT;
import org.nrg.xdat.bean.XnatImagescandataBean;
import org.nrg.xdat.bean.XnatImagesessiondataBean;
import org.nrg.xdat.bean.XnatMrscandataBean;
import org.nrg.xdat.bean.base.BaseElement;
import org.nrg.xdat.bean.reader.XDATXMLReader;
import org.nrg.xft.XFTItem;
import org.nrg.xft.collections.ItemCollection;
import org.nrg.xft.search.ItemSearch;

public class Session {
    private String sessionId;
    private String sessionLabel;
    private static Logger logger = Logger.getLogger(Session.class);
    private XnatImagesessiondataBean imageSession;

    public Session(String sessionId) {
        this.sessionId = sessionId;
        this.setSessionBean();
    }

    private void setSessionBean() {
        try {
            ItemCollection mrs = ItemSearch.GetItems((String)"xnat:imagesessionData.ID", (Object)this.sessionId, null, (boolean)false);
            XFTItem mrsession = (XFTItem)mrs.getFirst();
            XDATXMLReader xdatXmlReader = new XDATXMLReader();
            BaseElement baseElement = xdatXmlReader.parse((InputStream)new ByteArrayInputStream(mrsession.toXML_BOS(null).toByteArray()));
            this.imageSession = (XnatImagesessiondataBean)baseElement;
            if (this.imageSession != null) {
                this.setSessionLabel(this.imageSession.getLabel());
            }
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
    }

    private boolean isScanIsotropic(Double d_voxel_x, Double d_voxel_y, Double d_voxel_z) {
        boolean rtn = false;
        if (d_voxel_x == null || d_voxel_y == null || d_voxel_z == null) {
            return rtn;
        }
        double threshold = 0.5;
        double voxel_x = d_voxel_x;
        double voxel_y = d_voxel_y;
        double voxel_z = d_voxel_z;
        if (Math.abs(voxel_x - voxel_y) < threshold && Math.abs(voxel_x - voxel_z) < threshold) {
            rtn = true;
        } else if (Math.abs(voxel_x - voxel_y) < threshold && Math.abs(voxel_y - voxel_z) < threshold) {
            rtn = true;
        } else if (Math.abs(voxel_x - voxel_z) < threshold && Math.abs(voxel_z - voxel_y) < threshold) {
            rtn = true;
        }
        return rtn;
    }

    private void insertViewableOrientations(DBFSXMLInfo db_fs_xml, XFTItem item) throws Exception {
        if (this.isScanIsotropic(item.getDoubleProperty("parameters/voxelRes/x"), item.getDoubleProperty("parameters/voxelRes/y"), item.getDoubleProperty("parameters/voxelRes/z"))) {
            db_fs_xml.setViewableOrienations(item.getProperty("id"), this.getAcquiredOrientation());
        } else {
            db_fs_xml.setViewableOrienations(item.getProperty("id"), this.getAcquiredOrientation(item.getStringProperty("parameters/orientation")));
        }
    }

    private void insertViewableOrientations(DBFSXMLInfo db_fs_xml, XnatImagescandataBean scan) throws Exception {
        if (scan instanceof XnatMrscandataBean) {
            this.insertViewableOrientations(db_fs_xml, (XnatMrscandataBean)scan);
        } else {
            db_fs_xml.setViewableOrienations(scan.getId(), this.getAcquiredOrientation(null));
        }
    }

    private void insertViewableOrientations(DBFSXMLInfo db_fs_xml, XnatMrscandataBean mrScan) throws Exception {
        if (this.isScanIsotropic(mrScan.getParameters_voxelres_x(), mrScan.getParameters_voxelres_y(), mrScan.getParameters_voxelres_z())) {
            db_fs_xml.setViewableOrienations(mrScan.getId(), this.getAcquiredOrientation());
        } else {
            db_fs_xml.setViewableOrienations(mrScan.getId(), this.getAcquiredOrientation(mrScan.getParameters_orientation()));
        }
    }

    private Vector getAcquiredOrientation(String ori) {
        String tra = "Transverse     ";
        String sag = "Sagittal       ";
        String cor = "Coronal        ";
        String acquired = "As Acquired    ";
        if (ori == null) {
            Vector<String> orientation = new Vector<String>();
            orientation.add(acquired);
            return orientation;
        }
        Vector<String> orientation = new Vector<String>();
        if (ori.toUpperCase().startsWith("TRA")) {
            orientation.add(tra);
        } else if (ori.toUpperCase().startsWith("SAG")) {
            orientation.add(sag);
        } else if (ori.toUpperCase().startsWith("COR")) {
            orientation.add(cor);
        }
        return orientation;
    }

    private Vector getAcquiredOrientation() {
        String tra = "Transverse     ";
        String sag = "Sagittal       ";
        String cor = "Coronal        ";
        Vector<String> orientation = new Vector<String>();
        orientation.add(tra);
        orientation.add(sag);
        orientation.add(cor);
        return orientation;
    }

    public XnatImagesessiondataBean get() {
        return this.imageSession;
    }

    public static void main(String[] args) {
        try {
            XDAT.init((String)"C:\\DATA\\xdat_release_cnda_live\\deployments\\cnda_xnat");
            Session mrSession = new Session("neo225a");
            System.out.println("Session is inited");
            XnatImagesessiondataBean xnatImagesessiondataBean = mrSession.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSessionLabel() {
        return this.sessionLabel;
    }

    public void setSessionLabel(String sessionLabel) {
        this.sessionLabel = sessionLabel;
    }
}

