/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils.Transform;

import ij.ImagePlus;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import org.nrg.plexiViewer.io.PlexiFileOpener;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.xml.HiRes;

public class PlexiIntensitySetter {
    boolean reset = false;
    double min;
    double max;

    public PlexiIntensitySetter(HiRes hRes) {
        if (hRes.getMaxIntensity() != null) {
            this.max = hRes.getMaxIntensity().floatValue();
            this.reset = true;
        }
        if (hRes.getMinIntensity() != null) {
            this.min = hRes.getMinIntensity().floatValue();
            this.reset = true;
        }
        System.out.println("PlexiIntensitySetter::reset " + this.reset);
        System.out.println("Desired intensity range Min " + this.min + " max " + this.max);
    }

    public PlexiIntensitySetter(float minIntensity, float maxIntensity) {
        this.min = minIntensity;
        this.max = maxIntensity;
        this.reset = true;
        System.out.println("PlexiIntensitySetter::reset " + this.reset);
        System.out.println("Desired intensity range Min " + this.min + " max " + this.max);
    }

    public void setIntensities(ImagePlus image, boolean entireStack) {
        if (!this.reset) {
            return;
        }
        if (image.getType() != 0) {
            System.out.println("Cannot set intensities:: Image not of GRAY8");
            return;
        }
        ImageProcessor ip = image.getProcessor();
        ip.setRoi(image.getRoi());
        int[] table = new int[256];
        for (int i = 0; i < 256; ++i) {
            table[i] = (double)i <= this.min ? 0 : ((double)i >= this.max ? 255 : (int)(((double)i - this.min) / (this.max - this.min) * 255.0));
        }
        if (image.getStackSize() > 1) {
            if (entireStack) {
                ImageProcessor mask = image.getMask();
                for (int i = 1; i <= image.getStackSize(); ++i) {
                    image.setSlice(i);
                    ip = image.getProcessor();
                    if (mask != null) {
                        ip.snapshot();
                    }
                    ip.applyTable(table);
                    ip.reset(mask);
                }
            } else {
                if (ip.getMask() != null) {
                    ip.snapshot();
                }
                ip.applyTable(table);
                ip.reset(ip.getMask());
            }
        } else {
            if (ip.getMask() != null) {
                ip.snapshot();
            }
            ip.applyTable(table);
            ip.reset(ip.getMask());
        }
        this.reset(image, ip);
        image.changes = true;
        table = null;
    }

    void reset(ImagePlus imp, ImageProcessor ip) {
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            ip.resetMinAndMax();
        }
        double ipmin = ip.getMin();
        double ipmax = ip.getMax();
        ip.setMinAndMax(ipmin, ipmax);
    }

    public static void main(String[] args) {
        try {
            PlexiImageFile pf = new PlexiImageFile();
            pf.setURIAsString("file:/C:/data/cache/FTest2/061121_tc22923/061121_tc22923_mpr_n2_111_t88_gfc.4dfp_8bit_tra");
            pf.setXsiType("xnat:imageResource");
            PlexiFileOpener pfo = new PlexiFileOpener("ANALYZE", pf);
            ImagePlus img = pfo.getImagePlus();
            PlexiIntensitySetter i = new PlexiIntensitySetter(0.0f, 3.0f);
            i.setIntensities(img, true);
            img.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

