/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class UNRLE {
    static final boolean report_times = true;
    static final boolean report_size = true;
    FileOutputStream out = null;
    FileInputStream in = null;
    byte[] array = new byte[1];

    void putc(int i) throws IOException {
        this.out.write((byte)i);
    }

    int getc() throws IOException {
        int rb = this.in.read(this.array, 0, 1);
        if (rb == -1) {
            return -1;
        }
        return this.array[0] & 0xFF;
    }

    int getc(DataInputStream input) throws IOException {
        int rb = input.read(this.array, 0, 1);
        if (rb == -1) {
            return -1;
        }
        return this.array[0] & 0xFF;
    }

    public void decompress(String input_file, String output_file) throws IOException {
        long start_time = System.currentTimeMillis();
        try {
            int c;
            this.in = new FileInputStream(input_file);
            this.out = new FileOutputStream(output_file);
            int last = -1;
            int lastbo = -2;
            while ((c = this.getc()) >= 0) {
                this.putc(c);
                if (lastbo == last && c == last) {
                    int count = this.getc();
                    if (count < 0) break;
                    while ((c = this.getc()) == last) {
                        count += 256;
                    }
                    if (c < 0) {
                        count += count % 256 == 0 ? 256 : 0;
                    }
                    while (count-- > 0) {
                        this.putc(last);
                    }
                    if (c < 0) break;
                    this.putc(c);
                }
                lastbo = last;
                last = c;
            }
            this.in.close();
            this.out.close();
        }
        catch (Exception e) {
            UNRLE.printf("\nError while processing file:");
            e.printStackTrace();
        }
        start_time = System.currentTimeMillis() - start_time;
        UNRLE.printf("Time taken:" + (float)(start_time / 10L) / 100.0f + " seconds.");
        File f1 = new File(input_file);
        UNRLE.printf("Original file size:   " + f1.length() + " bytes.");
        File f2 = new File(output_file);
        UNRLE.printf("Compressed file size: " + f2.length() + " bytes.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList decompress(DataInputStream input) throws IOException {
        ArrayList<Integer> bytes = new ArrayList<Integer>();
        long start_time = System.currentTimeMillis();
        try {
            int c;
            int last = -1;
            int lastbo = -2;
            while ((c = this.getc(input)) >= 0) {
                bytes.add(new Integer(c));
                if (lastbo == last && c == last) {
                    int count = this.getc(input);
                    if (count < 0) {
                        break;
                    }
                    while ((c = this.getc(input)) == last) {
                        count += 256;
                    }
                    if (c < 0) {
                        count += count % 256 == 0 ? 256 : 0;
                    }
                    while (count-- > 0) {
                        bytes.add(new Integer(last));
                    }
                    if (c < 0) {
                        break;
                    }
                    bytes.add(new Integer(c));
                }
                lastbo = last;
                last = c;
            }
        }
        catch (Exception e) {
            UNRLE.printf("\nError while processing file:");
            e.printStackTrace();
        }
        finally {
            input.close();
        }
        start_time = System.currentTimeMillis() - start_time;
        UNRLE.printf("Time taken:" + (float)(start_time / 10L) / 100.0f + " seconds.");
        return bytes;
    }

    static void printf(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) throws IOException {
        UNRLE da = new UNRLE();
        String input_file = null;
        String output_file = null;
        UNRLE.printf("Bijective RLE decompressor version of July 12, 2001.");
        if (args.length > 0) {
            input_file = args[0];
            UNRLE.printf("Compressed file: " + args[0]);
        } else {
            UNRLE.printf("Error: No input file specified");
            System.exit(0);
        }
        if (args.length > 1) {
            output_file = args[1];
            UNRLE.printf("Decompressed file: " + args[1]);
        } else {
            UNRLE.printf("Error: No output file specified");
            System.exit(0);
        }
        da.decompress(input_file, output_file);
    }
}

