/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class URIUtils {
    String path = null;
    String name = null;
    URI uri;
    private boolean isSrb = false;

    public URIUtils(URI u) {
        this.uri = u;
        this.init();
    }

    public URIUtils(String u) {
        String u1 = u;
        try {
            u1 = u.replace("\\", "/");
            this.uri = new URI(u1);
            this.init();
        }
        catch (URISyntaxException urie) {
            System.out.println("URIUtils::constructor invalid uri " + u1);
            this.uri = null;
        }
    }

    private void init() {
        try {
            if (this.uri != null) {
                this.set();
            }
        }
        catch (IOException ioe) {
            System.out.println("URIUtils::init " + this.uri.toString());
        }
    }

    public boolean isRemote() {
        return this.isSrb;
    }

    public String getPath() throws IOException {
        if (this.path == null) {
            this.set();
        }
        return this.path;
    }

    public String getName() throws IOException {
        if (this.name == null) {
            this.set();
        }
        return this.name;
    }

    public static URI getURI(String rootStr) throws URISyntaxException {
        String root = rootStr.replace("\\", "/");
        URI base = null;
        if (!root.startsWith("srb:")) {
            File f = null;
            f = root.startsWith("file:") ? new File(new URI(root)) : new File(root);
            base = f.toURI();
        } else {
            base = new URI(root);
        }
        return base;
    }

    public static String stripScheme(String uri) {
        String rtn = uri;
        try {
            URI u = new URI(uri);
            rtn = u.getPath();
            if (rtn.startsWith("/")) {
                rtn = rtn.substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }

    private void set() throws IOException {
        if (this.uri.getScheme() != null && this.uri.getScheme().startsWith("file")) {
            File f = new File(this.uri);
            this.name = f.getName();
            this.path = f.getPath();
            int purePathIndex = this.path.indexOf(this.name);
            if (purePathIndex != -1 && purePathIndex > 1) {
                this.path = this.path.substring(0, purePathIndex - 1);
            }
        } else if (this.uri.getScheme() != null && this.uri.getScheme().startsWith("srb")) {
            this.isSrb = true;
            this.path = this.uri.getPath();
            int nI = this.path.lastIndexOf("/");
            if (nI != -1 && nI < this.path.length()) {
                this.name = this.path.substring(nI + 1);
                this.path = this.path.substring(0, nI);
            }
        }
    }

    public static void main(String[] args) {
        String uri = "srb://dmarcus@wustl-nrg-gpop.nbirn.net/home/dmarcus.wustl-nrg/oasis/set1/disc1/OAS1_0001_MR1/PROCESSED/MPRAGE/T88_111/OAS1_0001_MR1_mpr_n4_anon_111_t88_gfc.img";
        try {
            URIUtils u = new URIUtils(uri);
            System.out.println("Is Remote " + u.isRemote());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

