/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UnzipFile {
    public void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public void unzip(String srcPath, String destPath) {
        System.out.println("UnzipFile unzipping " + srcPath + " to " + destPath);
        try {
            ZipFile zipFile = new ZipFile(srcPath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    System.err.println("Extracting directory: " + entry.getName());
                    new File(entry.getName()).mkdir();
                    continue;
                }
                System.err.println("Extracting file: " + entry.getName());
                this.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(destPath + File.separator + entry.getName())));
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            System.err.println("Unhandled exception:");
            ioe.printStackTrace();
            return;
        }
    }

    public void gunzip(String srcPath, String destPath) {
        GZIPInputStream zipin;
        String source;
        String zipname;
        int sChunk = 8192;
        if (srcPath.endsWith(".gz")) {
            zipname = srcPath;
            source = srcPath.substring(0, srcPath.length() - 3);
        } else {
            zipname = srcPath + ".gz";
            source = srcPath;
        }
        File inFile = new File(source);
        File outFile = new File(destPath + File.separator + inFile.getName());
        try {
            FileInputStream in = new FileInputStream(zipname);
            zipin = new GZIPInputStream(in);
        }
        catch (IOException e) {
            System.out.println("Couldn't open " + zipname + ".");
            return;
        }
        byte[] buffer = new byte[sChunk];
        try {
            int length;
            FileOutputStream out = new FileOutputStream(outFile.getAbsolutePath());
            while ((length = zipin.read(buffer, 0, sChunk)) != -1) {
                out.write(buffer, 0, length);
            }
            out.close();
        }
        catch (IOException e) {
            System.out.println("Couldn't decompress " + srcPath + ".");
        }
        try {
            zipin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

