/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.DataWriter;
import org.dcm4che2.net.DataWriterAdapter;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DimseRSPHandler;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.TransferCapability;
import org.nrg.dcm.CStoreException;
import org.nrg.dcm.CStoreRSPHandler;
import org.nrg.dcm.DimseRSPStatusHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomSender {
    private static final String[] IVLE_TS = new String[]{"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2"};
    private static final String[] EVLE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2", "1.2.840.10008.1.2.2"};
    private static final String[] EVBE_TS = new String[]{"1.2.840.10008.1.2.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static final String DEVICE_NAME = "DicomSender";
    private static final String THREAD_EXECUTOR_NAME = "DicomSender";
    private final Logger logger = LoggerFactory.getLogger(DicomSender.class);
    private Association assoc;
    private final String[] tsuids;
    private final int priority = 0;
    private final NetworkApplicationEntity localAE;
    private final NetworkApplicationEntity remoteAE;
    private final Device device;

    public DicomSender(NetworkApplicationEntity localAE, NetworkApplicationEntity remoteAE) {
        this.localAE = localAE;
        this.remoteAE = remoteAE;
        this.device = new Device("DicomSender");
        this.device.setNetworkApplicationEntity(this.localAE);
        this.device.setNetworkConnection(localAE.getNetworkConnection());
        HashSet<String> tsuids = new HashSet<String>();
        for (TransferCapability tc : localAE.getTransferCapability()) {
            if (!tc.isSCU()) continue;
            tsuids.addAll(Arrays.asList(tc.getTransferSyntax()));
        }
        this.tsuids = tsuids.toArray(new String[0]);
        this.assoc = null;
    }

    private static InputStream openURI(URI uri) throws IOException {
        String scheme = uri.getScheme();
        if (null == scheme || "file".equals(scheme)) {
            return new FileInputStream(uri.getPath());
        }
        if ("resource".equalsIgnoreCase(scheme)) {
            return DicomSender.class.getClassLoader().getResourceAsStream(uri.getPath());
        }
        try {
            return uri.toURL().openStream();
        }
        catch (MalformedURLException e) {
            return new FileInputStream(uri.getPath());
        }
    }

    private static String toKeyStoreType(String fname) {
        return null == fname ? null : (fname.matches(".*\\.[pP]12\\Z") ? "PKCS12" : "JKS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(String uri, char[] password) throws IOException, GeneralSecurityException {
        InputStream is;
        if (null == uri) {
            return null;
        }
        KeyStore key = KeyStore.getInstance(DicomSender.toKeyStoreType(uri));
        try {
            is = DicomSender.openURI(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new FileNotFoundException("invalid keystore URI " + e.getMessage());
        }
        try {
            key.load(is, password);
            KeyStore keyStore = key;
            return keyStore;
        }
        finally {
            is.close();
        }
    }

    public void initTLS(String keyStoreURL, String keyStorePass, String keyPass, String trustStoreURL, String trustStorePass) throws IOException, GeneralSecurityException {
        char[] ksp = null == keyStorePass ? null : keyStorePass.toCharArray();
        KeyStore keyStore = DicomSender.loadKeyStore(keyStoreURL, ksp);
        char[] tsp = null == trustStorePass ? null : trustStorePass.toCharArray();
        KeyStore trustStore = DicomSender.loadKeyStore(trustStoreURL, tsp);
        this.device.initTLS(keyStore, null == keyPass ? ksp : keyPass.toCharArray(), trustStore);
    }

    public void setSSLContext(SSLContext context) {
        this.device.setSSLContext(context);
    }

    private String selectTransferSyntax(String[] available, String tsuid) {
        if ("1.2.840.10008.1.2".equals(tsuid)) {
            return this.selectTransferSyntax(available, IVLE_TS);
        }
        if ("1.2.840.10008.1.2.1".equals(tsuid)) {
            return this.selectTransferSyntax(available, EVLE_TS);
        }
        if ("1.2.840.10008.1.2.2".equals(tsuid)) {
            return this.selectTransferSyntax(available, EVBE_TS);
        }
        return tsuid;
    }

    private String selectTransferSyntax(String[] available, String[] tsuids) {
        for (int i = 0; i < tsuids.length; ++i) {
            for (int j = 0; j < available.length; ++j) {
                if (!available[j].equals(tsuids[i])) continue;
                return available[j];
            }
        }
        return null;
    }

    private Association connect() throws ConfigurationException, IOException, InterruptedException {
        return this.localAE.connect(this.remoteAE, (Executor)new NewThreadExecutor("DicomSender"));
    }

    public String send(DicomObject o, String tsuid) throws IOException, CStoreException {
        if (null == this.assoc || !this.assoc.isReadyForDataTransfer()) {
            try {
                this.assoc = this.connect();
            }
            catch (ConfigurationException e) {
                this.logger.error("association configuration failed", (Throwable)e);
                throw new IOException("unable to configure association: " + e.getMessage());
            }
            catch (InterruptedException e) {
                this.logger.error("unable to (re)open association", (Throwable)e);
                throw new IOException("thread interrupted opening association: " + e.getMessage());
            }
        }
        String cuid = o.getString(524310);
        String iuid = o.getString(524312);
        tsuid = this.selectTransferSyntax(this.tsuids, tsuid);
        CStoreRSPHandler rsph = new CStoreRSPHandler();
        try {
            this.assoc.cstore(cuid, iuid, 0, (DataWriter)new DataWriterAdapter(o), tsuid, (DimseRSPHandler)rsph);
            this.assoc.waitForDimseRSP();
        }
        catch (InterruptedException e) {
            this.logger.error("send interrupted", (Throwable)e);
        }
        DimseRSPStatusHandler.ServiceStatus status = rsph.getStatus();
        if (DimseRSPStatusHandler.ServiceStatus.SUCCESS == status) {
            return null;
        }
        if (DimseRSPStatusHandler.ServiceStatus.WARNING == status) {
            return rsph.toString();
        }
        if (DimseRSPStatusHandler.ServiceStatus.FAILURE == status) {
            throw new CStoreException(rsph.toString());
        }
        throw new RuntimeException("Undefined ServiceStatus " + (Object)((Object)status));
    }

    public void close() {
        try {
            if (null != this.assoc) {
                this.assoc.release(false);
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("release interrupted", (Throwable)e);
        }
    }

    public void abort() {
        this.assoc.abort();
    }
}

