/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.nrg.dcm.RequiredAttributeUnsetException;

public final class DicomUtils {
    private static final String GZIP_SUFFIX = ".gz";

    private DicomUtils() {
    }

    public static String getStringRequired(DicomObject o, int tag) throws RequiredAttributeUnsetException {
        String v = o.getString(tag);
        if (null == v || "".equals(v)) {
            throw new RequiredAttributeUnsetException(o, tag);
        }
        return v;
    }

    public static String getTransferSyntaxUID(DicomObject o) {
        return o.getString(131088, "1.2.840.10008.1.2");
    }

    private static StopTagInputHandler getStopTagInputHandler(int maxTag) {
        if (maxTag > 0) {
            return new StopTagInputHandler(maxTag + 1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DicomObject read(InputStream in, DicomInputHandler handler) throws IOException {
        IOException ioexception = null;
        BufferedInputStream bin = new BufferedInputStream(in);
        try {
            DicomInputStream din;
            block18: {
                DicomObject o;
                din = new DicomInputStream((InputStream)bin);
                if (null != handler) {
                    din.setHandler(handler);
                }
                if (!(o = din.readDicomObject()).contains(524310)) break block18;
                DicomObject dicomObject = o;
                try {
                    din.close();
                }
                catch (IOException e) {
                    ioexception = null == ioexception ? e : ioexception;
                    throw ioexception;
                }
                try {
                    bin.close();
                    return dicomObject;
                }
                catch (IOException e) {
                    ioexception = null == ioexception ? e : ioexception;
                    throw ioexception;
                }
            }
            try {
                try {
                    throw new IOException("no SOP class UID in prospective DICOM object");
                }
                catch (IOException e) {
                    ioexception = e;
                    throw ioexception;
                }
                catch (Throwable t) {
                    throw new IOException("unable to read as DICOM", t);
                }
            }
            catch (Throwable throwable) {
                try {
                    din.close();
                    throw throwable;
                }
                catch (IOException e) {
                    ioexception = null == ioexception ? e : ioexception;
                    throw ioexception;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                bin.close();
                throw throwable;
            }
            catch (IOException e) {
                ioexception = null == ioexception ? e : ioexception;
                throw ioexception;
            }
        }
    }

    public static DicomObject read(InputStream in, int maxTag) throws IOException {
        return DicomUtils.read(in, (DicomInputHandler)DicomUtils.getStopTagInputHandler(maxTag));
    }

    public static DicomObject read(InputStream in) throws IOException {
        return DicomUtils.read(in, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DicomObject read(File file, DicomInputHandler handler) throws IOException {
        DicomObject dicomObject;
        InputStream fin = new FileInputStream(file);
        IOException ioexception = null;
        try {
            if (file.getName().endsWith(GZIP_SUFFIX)) {
                fin = new GZIPInputStream(fin);
            }
            dicomObject = DicomUtils.read(fin, handler);
        }
        catch (IOException e) {
            try {
                ioexception = e;
                throw ioexception;
            }
            catch (Throwable throwable) {
                try {
                    fin.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    IOException iOException;
                    if (null == ioexception) {
                        iOException = e2;
                        throw iOException;
                    }
                    iOException = ioexception;
                    throw iOException;
                }
            }
        }
        try {
            fin.close();
            return dicomObject;
        }
        catch (IOException e) {
            IOException iOException;
            if (null == ioexception) {
                iOException = e;
                throw iOException;
            }
            iOException = ioexception;
            throw iOException;
        }
    }

    public static DicomObject read(File file, int maxTag) throws IOException {
        return DicomUtils.read(file, (DicomInputHandler)DicomUtils.getStopTagInputHandler(maxTag));
    }

    public static DicomObject read(File file) throws IOException {
        return DicomUtils.read(file, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DicomObject read(URI uri, DicomInputHandler handler) throws IOException, MalformedURLException {
        DicomObject dicomObject;
        if ("file".equals(uri.getScheme())) {
            return DicomUtils.read(new File(uri), handler);
        }
        if (!uri.isAbsolute()) throw new IllegalArgumentException("URIs must be absolute");
        URL url = uri.toURL();
        InputStream in = url.openStream();
        IOException ioexception = null;
        try {
            dicomObject = DicomUtils.read(in, handler);
        }
        catch (IOException e) {
            try {
                ioexception = e;
                throw ioexception;
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    ioexception = null == ioexception ? e2 : ioexception;
                    throw ioexception;
                }
            }
        }
        try {
            in.close();
            return dicomObject;
        }
        catch (IOException e) {
            ioexception = null == ioexception ? e : ioexception;
            throw ioexception;
        }
    }

    public static DicomObject read(URI uri, int maxTag) throws IOException, MalformedURLException {
        return DicomUtils.read(uri, (DicomInputHandler)DicomUtils.getStopTagInputHandler(maxTag));
    }

    public static DicomObject read(URI uri) throws IOException, MalformedURLException {
        return DicomUtils.read(uri, null);
    }

    public static StringBuilder stripTrailingChars(StringBuilder sb, char toStrip) {
        for (int i = sb.length() - 1; i >= 0 && toStrip == sb.charAt(i); --i) {
            sb.deleteCharAt(i);
        }
        return sb;
    }

    public static String stripTrailingChars(String s, char toStrip) {
        return DicomUtils.stripTrailingChars(new StringBuilder(s), toStrip).toString();
    }
}

