/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat.var;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nrg.ecat.AbstractHeaderModification;
import org.nrg.ecat.Header;
import org.nrg.ecat.HeaderModification;
import org.nrg.ecat.var.AbstractVariable;

public final class CharacterVariable
extends AbstractVariable {
    private static final String CHARSET_NAME = "US-ASCII";
    private final int size;

    public CharacterVariable(Header.Type type, String name, int offset, int size) {
        super(type, name, offset);
        this.size = size;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" Character*").append(this.size);
        return sb.toString();
    }

    @Override
    public Object readValue(InputStream in) throws IOException {
        int len;
        byte[] bytes = CharacterVariable.readFull(in, this.size);
        for (len = 0; len < this.size && 0 != bytes[len]; ++len) {
        }
        return new String(bytes, 0, len, CHARSET_NAME);
    }

    @Override
    public HeaderModification createClearModification() {
        return this.createClearModification(this.size);
    }

    @Override
    public HeaderModification createValueModification(Object value) {
        final byte[] bytes = new byte[this.size];
        if (null != value) {
            String v = value.toString();
            System.arraycopy(v.getBytes(), 0, bytes, 0, Math.min(this.size, v.length()));
        }
        return new AbstractHeaderModification(this.getHeaderType(), this.getOffset()){

            @Override
            public int modify(OutputStream to, InputStream from) throws IOException {
                AbstractVariable.readFull(from, CharacterVariable.this.size);
                to.write(bytes);
                return CharacterVariable.this.size;
            }
        };
    }
}

