/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dcm4che2.data.UID;

public final class SOPModel {
    public static final String XNAT_SCAN_COLUMN = "XNAT_SCAN_ID";
    private static final String LEAD_SCAN_TYPE_R = "/lead-scan-types.txt";
    private static final String LEAD_SESSION_TYPE_R = "/lead-session-types.txt";
    private static final String LEAD_MODALITY_R = "/lead-modalities.txt";
    private static final String SOP_TO_SCAN_TYPE_R = "/series-scans.properties";
    private static final String SOP_TO_SESSION_TYPE_R = "/study-sessions.properties";
    private static final String MODALITY_TO_SESSION_TYPE_R = "/modality-sessions.properties";
    private static final String PRIMARY_SOP_UID_R = "/primary-sops.txt";
    private static final Function<String, String> uidForName = new Function<String, String>(){

        public String apply(String name) {
            try {
                Field f = UID.class.getDeclaredField(name);
                return (String)f.get(null);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                return name;
            }
        }
    };
    private static final ImmutableMap<String, String> SOP_TO_SCAN_TYPE = SOPModel.getStringMapFromResource("/series-scans.properties", uidForName);
    private static final ImmutableMap<String, String> SOP_TO_SESSION_TYPE = SOPModel.getStringMapFromResource("/study-sessions.properties", uidForName);
    private static final ImmutableMap<String, String> MODALITY_TO_SESSION_TYPE = SOPModel.getStringMapFromResource("/modality-sessions.properties", null);
    private static final Set<String> PRIMARY_SOP_UIDS = ImmutableSet.copyOf((Collection)Lists.transform(SOPModel.getStringsFromResource("/primary-sops.txt"), uidForName));
    private static final List<String> LEAD_SCAN_TYPES = SOPModel.getStringsFromResource("/lead-scan-types.txt");
    private static final List<String> LEAD_SESSION_TYPES = SOPModel.getStringsFromResource("/lead-session-types.txt");
    private static final List<String> LEAD_MODALITIES = SOPModel.getStringsFromResource("/lead-modalities.txt");

    private SOPModel() {
    }

    /*
     * Loose catch block
     */
    private static final ImmutableList<String> getStringsFromResource(String path) {
        InputStream in = SOPModel.class.getResourceAsStream(path);
        if (null == in) {
            throw new RuntimeException("resource /primary-sops.txt not found");
        }
        IOException ioexception = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        while (null != line) {
            builder.add((Object)line.trim());
            line = reader.readLine();
        }
        line = builder.build();
        try {
            reader.close();
        }
        catch (IOException e) {
            ioexception = null == ioexception ? e : ioexception;
            throw ioexception;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            throw null == ioexception ? e : ioexception;
        }
        return line;
        {
            catch (IOException e) {
                try {
                    try {
                        try {
                            ioexception = e;
                            throw ioexception;
                        }
                        catch (Throwable throwable) {
                            try {
                                reader.close();
                            }
                            catch (IOException e2) {
                                ioexception = null == ioexception ? e2 : ioexception;
                                throw ioexception;
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (IOException e3) {
                            throw null == ioexception ? e3 : ioexception;
                        }
                        throw throwable;
                    }
                }
                catch (IOException e4) {
                    throw new RuntimeException("Unable to read resource " + path, e4);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final ImmutableMap<String, String> getStringMapFromResource(String path, Function<String, String> keyXform) {
        try {
            Properties p = new Properties();
            InputStream in = SOPModel.class.getResourceAsStream(path);
            if (null == in) {
                throw new RuntimeException("resource " + path + " not found");
            }
            IOException ioexception = null;
            try {
                p.load(in);
            }
            catch (IOException e) {
                try {
                    ioexception = e;
                    throw ioexception;
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        ioexception = null == ioexception ? e2 : ioexception;
                        throw ioexception;
                    }
                }
            }
            try {
                in.close();
            }
            catch (IOException e) {
                ioexception = null == ioexception ? e : ioexception;
                throw ioexception;
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            Iterator<Map.Entry<Object, Object>> i$ = p.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<Object, Object> me = i$.next();
                String key = me.getKey().toString();
                String k = null == keyXform ? key : (String)keyXform.apply((Object)key);
                builder.put((Object)k, (Object)me.getValue().toString());
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize SOP to XNAT model conversion", e);
        }
    }

    private static <T> T getLead(Iterable<T> options, Set<? extends T> values) {
        for (T t : options) {
            if (!values.contains(t)) continue;
            return t;
        }
        return null;
    }

    private static String getType(Iterable<String> sopClassUIDs, List<String> leadTypes, Map<String, String> types) {
        return SOPModel.getLead(leadTypes, ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(sopClassUIDs, (Function)Functions.forMap(types, null)), (Predicate)Predicates.notNull())));
    }

    public static String getScanType(String sopClassUID) {
        return (String)SOP_TO_SCAN_TYPE.get((Object)sopClassUID);
    }

    public static String getScanType(String ... sopClassUIDs) {
        return SOPModel.getScanType(Arrays.asList(sopClassUIDs));
    }

    public static String getScanType(Iterable<String> sopClassUIDs) {
        return SOPModel.getType(sopClassUIDs, LEAD_SCAN_TYPES, SOP_TO_SCAN_TYPE);
    }

    public static String getSessionType(Iterable<String> sopClassUIDs) {
        return SOPModel.getType(sopClassUIDs, LEAD_SESSION_TYPES, SOP_TO_SESSION_TYPE);
    }

    public static boolean isPrimaryImagingSOP(String sopClassUID) {
        return PRIMARY_SOP_UIDS.contains(sopClassUID);
    }

    public static String getLeadModality(Set<String> modalities) {
        return SOPModel.getLead(LEAD_MODALITIES, modalities);
    }

    public static ImmutableMap<String, String> getModalityToSessionTypes() {
        return MODALITY_TO_SESSION_TYPE;
    }

    public static ImmutableMap<String, String> getSOPClassToSessionTypes() {
        return SOP_TO_SESSION_TYPE;
    }
}

