/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.Extractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainExtractor
implements Extractor {
    private final Iterable<Extractor> extractors;
    private final SortedSet<Integer> tags;

    public ChainExtractor(Iterable<Extractor> extractors) {
        this.extractors = ImmutableList.copyOf(extractors);
        TreeSet ts = Sets.newTreeSet();
        for (Extractor extractor : extractors) {
            ts.addAll(extractor.getTags());
        }
        this.tags = ImmutableSortedSet.copyOf((Collection)ts);
    }

    public ChainExtractor(Extractor ... extractors) {
        this(Arrays.asList(extractors));
    }

    @Override
    public String extract(DicomObject o) {
        for (Extractor extractor : this.extractors) {
            String v = extractor.extract(o);
            if (Strings.isNullOrEmpty((String)v)) continue;
            return v;
        }
        return null;
    }

    @Override
    public SortedSet<Integer> getTags() {
        return this.tags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(":");
        Joiner.on((String)",").appendTo(sb, this.extractors);
        return sb.toString();
    }
}

