/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.xnat;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.DicomFileNamer;
import org.nrg.xnat.Files;
import org.nrg.xnat.Labels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SOPHashDicomFileNamer
implements DicomFileNamer {
    private static final String FIELD_SEPARATOR = ".";
    private static final String SUFFIX = ".dcm";
    private final Logger logger = LoggerFactory.getLogger(SOPHashDicomFileNamer.class);

    @Override
    public String makeFileName(DicomObject o) {
        int hash;
        String studyTime;
        ArrayList components = Lists.newArrayList();
        String studyID = o.getString(0x200010, "NULL");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Study {} @{} {} - {}:{}", (Object[])new String[]{o.getString(528432), o.getString(524320), o.getString(524336), o.getString(0x200011), o.getString(2097171)});
        }
        this.addIfNotNull(components, o.getString(0x100010, studyID), Labels.toLabelChars(o.getString(524384)), Labels.toLabelChars(o.getString(528432)), Labels.toLabelChars(o.getString(0x200011)), Labels.toLabelChars(o.getString(2097171)));
        String studyDate = o.getString(524320);
        if (null != studyDate) {
            components.add(studyDate.replace(FIELD_SEPARATOR, ""));
        }
        if (null != (studyTime = o.getString(524336))) {
            String fixedTime = studyTime.replace(":", "");
            int msecStart = studyTime.indexOf(FIELD_SEPARATOR);
            if (msecStart >= 6) {
                fixedTime = fixedTime.substring(0, msecStart);
            }
            components.add(fixedTime);
        }
        String sopClassUID = o.getString(524310);
        String instanceUID = o.getString(524312);
        int n = hash = null == sopClassUID ? 0 : sopClassUID.hashCode();
        if (null != instanceUID) {
            hash = 37 * instanceUID.hashCode() + hash;
        }
        components.add(Long.toString((long)hash & 0xFFFFFFFFL, 36));
        Joiner joiner = Joiner.on((String)FIELD_SEPARATOR);
        StringBuilder fileName = joiner.appendTo(new StringBuilder(), (Iterable)components);
        fileName.append(SUFFIX);
        return Files.toFileNameChars(fileName.toString());
    }

    private <T> Collection<T> addIfNotNull(Collection<T> coll, T ... ts) {
        for (T t : ts) {
            if (null == t) continue;
            coll.add(t);
        }
        return coll;
    }
}

