/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.xnat;

import java.io.File;
import java.util.regex.Pattern;

public final class Files {
    private static final String nonFileCharRE = "[^\\w.-]";
    private static final String fileNameRE = "[\\w.-]+";
    private static final Pattern nonFileCharsPattern = Pattern.compile("[^\\w.-]");
    private static final Pattern fileNamePattern = Pattern.compile("[\\w.-]+");
    private static final String FORMAT_NAME = "DICOM";
    private static final String SCANS_DIR_NAME = "SCANS";
    private static final String RESOURCES_DIR_NAME = "RESOURCES";

    private Files() {
    }

    public static String toFileNameChars(CharSequence s) {
        return null == s ? null : nonFileCharsPattern.matcher(s).replaceAll("_");
    }

    public static boolean isValidFilename(CharSequence s) {
        return null != s && fileNamePattern.matcher(s).matches();
    }

    public static File getImageFile(File sessionDirectory, String scan, String name) {
        File dataDir;
        if (null == scan) {
            File resourcesDir = new File(sessionDirectory, RESOURCES_DIR_NAME);
            dataDir = new File(resourcesDir, FORMAT_NAME);
        } else {
            File scansDir = new File(sessionDirectory, SCANS_DIR_NAME);
            File scanDir = new File(scansDir, scan);
            dataDir = new File(scanDir, FORMAT_NAME);
        }
        return new File(dataDir, name);
    }
}

