/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.xdat.bean.reader;

import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileInputStream;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.zip.GZIPInputStream;
import org.nrg.xdat.bean.base.BaseElement;
import org.nrg.xdat.bean.reader.XDATXMLReader;
import org.nrg.xnat.srb.XNATSrbConnection;
import org.xml.sax.SAXException;

public class SRBXDATXMLReader
extends XDATXMLReader {
    public BaseElement parse(String fullPath) throws IOException, SAXException, URISyntaxException {
        if (fullPath.startsWith("srb:")) {
            String file = fullPath.substring(6);
            SRBFileSystem srbFileSystem = XNATSrbConnection.getSRBFileSystem();
            SRBFile srbFile = new SRBFile(srbFileSystem, file);
            if (!srbFile.exists()) {
                srbFile = new SRBFile(srbFileSystem, file + ".gz");
            }
            if (srbFile.exists()) {
                Object fis = new SRBFileInputStream(srbFile);
                if (srbFile.getName().endsWith(".gz")) {
                    fis = new GZIPInputStream((InputStream)fis);
                }
                return this.parse((InputStream)fis);
            }
            throw new IOException(file + " File " + fullPath + " or " + fullPath + ".gz" + " not found");
        }
        File f = new File(fullPath);
        if (!f.exists()) {
            f = new File(fullPath + ".gz");
        }
        if (f.exists()) {
            InputStream fis = new FileInputStream(f);
            if (f.getName().endsWith(".gz")) {
                fis = new GZIPInputStream(fis);
            }
            return this.parse(fis);
        }
        throw new IOException("File " + fullPath + " or " + fullPath + ".gz" + " not found");
    }

    public static void main(String[] args) {
        SRBXDATXMLReader reader = new SRBXDATXMLReader();
        try {
            System.out.println(reader.parse("srb://test_SCAN1.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("All done");
    }
}

