/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.collect.Maps;
import java.util.Map;

public class BindingContext {
    private final Map<String, Object> defined = Maps.newHashMap();

    final void bind(String label, Object value) throws AlreadyBoundLabelException {
        String canonical = label.toLowerCase();
        if (this.defined.containsKey(canonical)) {
            throw new AlreadyBoundLabelException(canonical);
        }
        this.defined.put(canonical, value);
    }

    final Object getValue(String label) {
        String canonical = label.toLowerCase();
        if (this.defined.containsKey(canonical)) {
            return this.defined.get(canonical);
        }
        throw new UnboundLabelException(label);
    }

    public static class AlreadyBoundLabelException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        AlreadyBoundLabelException(String s) {
            super("Label already bound: " + s);
        }
    }

    public static class UnboundLabelException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        UnboundLabelException(String s) {
            super("Label not defined: " + s);
        }
    }
}

