/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.ConstraintMatch;
import org.nrg.dcm.edit.ScriptEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintConjunction
implements ConstraintMatch {
    private final Iterable<ConstraintMatch> predicates;

    public ConstraintConjunction(ConstraintMatch predicate) {
        this(Collections.singletonList(predicate));
    }

    public ConstraintConjunction(Iterable<ConstraintMatch> predicates) {
        this.predicates = Lists.newArrayList(predicates);
    }

    @Override
    public SortedSet<Integer> getTags() {
        TreeSet tags = Sets.newTreeSet();
        for (ConstraintMatch p : this.predicates) {
            tags.addAll(p.getTags());
        }
        return tags;
    }

    @Override
    public boolean matches(DicomObject o) throws ScriptEvaluationException {
        for (ConstraintMatch predicate : this.predicates) {
            if (predicate.matches(o)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConstraintConjunction: ");
        if (Iterables.isEmpty(this.predicates)) {
            sb.append("[TRUE]");
        } else {
            Joiner.on((String)" AND ").appendTo(sb, this.predicates);
        }
        return sb.toString();
    }
}

