/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.nrg.dcm.edit.AttributeVRMismatchException;

public final class DicomUtils {
    private static final Map<VR, Converter> conversions = ImmutableMap.of((Object)VR.SQ, (Object)new Converter(){

        public String convert(DicomObject o, DicomElement e) throws AttributeVRMismatchException {
            throw new AttributeVRMismatchException(e.tag(), e.vr());
        }
    }, (Object)VR.UN, (Object)new Converter(){

        public String convert(DicomObject o, DicomElement e) {
            return e.getString(o.getSpecificCharacterSet(), false);
        }
    }, (Object)VR.AT, (Object)new Converter(){

        public String convert(DicomObject o, DicomElement e) {
            return DicomUtils.join(e.getInts(false), "\\");
        }
    }, (Object)VR.OB, (Object)new Converter(){

        public String convert(DicomObject o, DicomElement e) {
            return VR.OB.toString(e.getBytes(), o.bigEndian(), o.getSpecificCharacterSet());
        }
    });
    private static final Pattern VALID_UID_PATTERN = Pattern.compile("(0|([1-9][0-9]*))(\\.(0|([1-9][0-9]*)))*");
    private static final int UID_MIN_LEN = 1;
    private static final int UID_MAX_LEN = 64;
    private static final TimeZone TIME_ZONE = Calendar.getInstance().getTimeZone();

    private DicomUtils() {
    }

    private static StringBuffer join(StringBuffer sb, int[] array, String separator) {
        if (array.length > 0) {
            sb.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                sb.append(separator);
                sb.append(array[i]);
            }
        }
        return sb;
    }

    private static String join(int[] array, String separator) {
        return DicomUtils.join(new StringBuffer(), array, separator).toString();
    }

    public static String getString(DicomObject o, int tag) throws AttributeVRMismatchException {
        DicomElement de = o.get(tag);
        if (null == de) {
            return null;
        }
        Converter converter = conversions.get(de.vr());
        if (null == converter) {
            try {
                return Joiner.on((String)"\\").join((Object[])de.getStrings(o.getSpecificCharacterSet(), false));
            }
            catch (UnsupportedOperationException e) {
                throw new AttributeVRMismatchException(tag, de.vr());
            }
        }
        return converter.convert(o, de);
    }

    public static boolean isValidUID(CharSequence uid) {
        if (null == uid) {
            return false;
        }
        int len = uid.length();
        if (len < 1 || 64 < len) {
            return false;
        }
        return VALID_UID_PATTERN.matcher(uid).matches();
    }

    public static final String getTransferSyntaxUID(DicomObject o) {
        return o.getString(131088, "1.2.840.10008.1.2");
    }

    public static Date getDateTime(DicomObject o, int dateTag, int timeTag) {
        Date date = o.getDate(dateTag);
        Date time = o.getDate(timeTag);
        if (null == date) {
            return time;
        }
        if (null == time) {
            return date;
        }
        if (TIME_ZONE.inDaylightTime(date)) {
            Calendar localTime = Calendar.getInstance(TIME_ZONE);
            localTime.setTime(date);
            Calendar fixTime = Calendar.getInstance();
            fixTime.setTime(time);
            localTime.set(11, fixTime.get(11));
            localTime.set(12, fixTime.get(12));
            return new Date(localTime.getTimeInMillis());
        }
        return new Date(date.getTime() + time.getTime() + (long)TIME_ZONE.getOffset(date.getTime()));
    }

    private static interface Converter {
        public String convert(DicomObject var1, DicomElement var2) throws AttributeVRMismatchException;
    }
}

