/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.GeneratorScope;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedValue
implements Value {
    private final GeneratorScope scope;
    private final int tag;
    private final String label;
    private final List<Value> params;

    public GeneratedValue(GeneratorScope scope, int tag, String label, List<Value> params) {
        this.scope = scope;
        this.tag = tag;
        this.label = label;
        this.params = ImmutableList.copyOf(params);
    }

    @Override
    public SortedSet<Integer> getTags() {
        TreeSet tags = Sets.newTreeSet();
        for (Value param : this.params) {
            tags.addAll(param.getTags());
        }
        return tags;
    }

    @Override
    public Set<Variable> getVariables() {
        LinkedHashSet vars = Sets.newLinkedHashSet();
        for (Value v : this.params) {
            vars.addAll(v.getVariables());
        }
        return vars;
    }

    @Override
    public String on(DicomObject o) throws ScriptEvaluationException {
        ArrayList values = Lists.newArrayListWithExpectedSize((int)this.params.size());
        for (Value v : this.params) {
            values.add(v.on(o));
        }
        return this.scope.getValue(this.label, this.tag, o.getString(this.tag), values);
    }

    @Override
    public String on(Map<Integer, String> m) throws ScriptEvaluationException {
        ArrayList values = Lists.newArrayListWithExpectedSize((int)this.params.size());
        for (Value v : this.params) {
            values.add(v.on(m));
        }
        return this.scope.getValue(this.label, this.tag, m.get(this.tag), values);
    }

    @Override
    public void replace(Variable var) {
        for (Value val : this.params) {
            val.replace(var);
        }
    }
}

