/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.ConstantValue;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageFormatValue
implements Value {
    private final Logger logger = LoggerFactory.getLogger(MessageFormatValue.class);
    private final Value format;
    private final List<Value> values;
    private final SortedSet<Integer> tags;
    private final Set<Variable> variables;

    public MessageFormatValue(Value format, Iterable<? extends Value> values) {
        this.format = format;
        this.values = Lists.newArrayList(values);
        LinkedHashSet tags = Sets.newLinkedHashSet();
        this.variables = Sets.newLinkedHashSet();
        for (Value value : values) {
            tags.addAll(value.getTags());
            this.variables.addAll(value.getVariables());
        }
        this.tags = ImmutableSortedSet.copyOf((Collection)tags);
    }

    public MessageFormatValue(String format, Iterable<? extends Value> values) {
        this(new ConstantValue(format), values);
    }

    @Override
    public SortedSet<Integer> getTags() {
        return this.tags;
    }

    @Override
    public Set<Variable> getVariables() {
        return this.variables;
    }

    @Override
    public String on(DicomObject o) throws ScriptEvaluationException {
        Object[] vals = new Object[this.values.size()];
        this.logger.trace("format values: {}", this.values);
        for (int i = 0; i < this.values.size(); ++i) {
            vals[i] = this.values.get(i).on(o);
        }
        this.logger.trace("format args: {}", vals);
        return MessageFormat.format(this.format.on(o), vals);
    }

    @Override
    public String on(Map<Integer, String> m) throws ScriptEvaluationException {
        Object[] vals = new Object[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            Value v = this.values.get(i);
            vals[i] = v.on(m);
        }
        return MessageFormat.format(this.format.on(m), vals);
    }

    @Override
    public void replace(Variable var) {
        this.format.replace(var);
        for (Value val : this.values) {
            val.replace(var);
        }
        if (this.variables.contains(var)) {
            this.variables.remove(var);
            this.variables.add(var);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof MessageFormatValue) {
            MessageFormatValue other = (MessageFormatValue)o;
            return this.format.equals(other.format) && this.values.equals(other.values);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.format, this.values});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("format(\"");
        sb.append(this.format).append("\"");
        for (Value v : this.values) {
            sb.append(", ").append(v);
        }
        sb.append(")");
        return sb.toString();
    }
}

